# Installation of LibCapy

## Prerequesites

You'll need the following tools to install LibCapy: `make`, `gcc (>=9)`, `pkg-config`, `gtk+-3.0`. They can be installed with the following commands:

* on Fedora: `sudo dnf install make gcc pkg-config gtk3-devel`
* on Ubuntu 20.04: `sudo apt -y install build-essential pkg-config libgtk-3-dev`.
* on Ubuntu 18.04: `sudo apt -y install build-essential pkg-config gcc-9 gtk+-3.0`, and to set gcc-9 as the default version: `sudo rm /usr/bin/gcc && sudo ln -s /usr/bin/gcc /usr/bin/gcc-9`.

## Installation

The default installation process consists of running the command `sudo make install` in the LibCapy repository's root folder (named `LIB_CAPY` in the rest of this document).

## Compilation options

`LIB_CAPY/Makefile` contains the following several variables to control the compilation process.

* COMPILER

The compiler used to compile the library. By default, it's `gcc`.

* BUILD_MODE

If equals to 0, the library is compiled in developpement mode. Compilation options are set for debugging with `gdb` and extra code may be included to assert the correctness of the execution or report more detailed information about errors.

If equals to 1, the library is compiled in production mode. Compilation options are set for more optimisation and treatment of any warning as a fatal error.

* INSTALL_DIR

The installation directory. The headers of the library are installed into `INSTALL_DIR/include/LibCapy` and the archive into `INSTALL_DIR/lib`. Make sure to have these folders into our paths to compile code using LibCapy. By default, it is `/usr/local`.

* CAPY_WITH_GUI

If you want to compile LibCapy without graphics functionalities, use `sudo make install WITH_GUI=0` instead.

## Test

After installing the library you can test it with the command `make test`. This command creates the file `testLibCapy.c` in the current directory, compiles it and runs it. If there is no problem, the compiled binary displays a welcome message with the version and commit of the library. Then the temporary files are removed.

