# LibCapy
LibCapy is a general purpose library of C functions and data structures.
## How to use it
* Install the library as explained in `INSTALL.md`.
* Include it in your code with `#include <LibCapy/capy.h>` as in the example below:
```
#include <LibCapy/capy.h>
int main() {
  println(
    "Welcome to LibCapy version %s",
    CapyGetVersion());
  return EXIT_SUCCESS;
}
```
* Compile your code using LibCapy as in the example Makefile below:
```
CAPY_PARAM=-std=c18 -I./ -Wall -Wextra -Wshadow -Wno-format-truncation -Werror -Wfatal-errors -O3 -ggdb -fopenmp -DPNG_SKIP_SETJMP_CHECK `pkg-config --cflags gtk+-3.0` -D_XOPEN_SOURCE=700 -DCAPY_WITH_GUI=1
CAPY_LINK=-lcapy -lm -fopenmp -lpng `pkg-config --libs gtk+-3.0` -lX11
main: main.o
	gcc -o main main.o $(CAPY_LINK)
main.o: main.c
	gcc -c main.c $(CAPY_PARAM)
```
* If you need to compile without the graphical functionalities (i.e. without GTK), use the example Makefile below instead:
```
CAPY_PARAM=-std=c18 -I./ -Wall -Wextra -Wshadow -Wno-format-truncation -Werror -Wfatal-errors -O3 -ggdb -fopenmp -DPNG_SKIP_SETJMP_CHECK -D_XOPEN_SOURCE=700 -DCAPY_WITH_GUI=0
CAPY_LINK=-lcapy -lm -fopenmp -lpng
main: main.o
	gcc -o main main.o $(CAPY_LINK)
main.o: main.c
	gcc -c main.c $(CAPY_PARAM)
```
## Versions
See `VERSION.md` for the details about each version.
