// --------------------------------- array.c ----------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "array.h"
#include "random.h"

// Definition of resizable arrays for some basic types
CapyDefArray(CapyArrChar, char)
CapyDefArray(CapyArrInt8, int8_t)
CapyDefArray(CapyArrUInt8, uint8_t)
CapyDefArray(CapyArrInt16, int16_t)
CapyDefArray(CapyArrUInt16, uint16_t)
CapyDefArray(CapyArrInt32, int32_t)
CapyDefArray(CapyArrUInt32, uint32_t)
CapyDefArray(CapyArrInt64, int64_t)
CapyDefArray(CapyArrUInt64, uint64_t)
CapyDefArray(CapyArrSize, size_t)
CapyDefArray(CapyArrFloat, float)
CapyDefArray(CapyArrDouble, double)
CapyDefArray(CapyArrPtrChar, char*)
CapyDefArray(CapyArrPtrInt8, int8_t*)
CapyDefArray(CapyArrPtrUInt8, uint8_t*)
CapyDefArray(CapyArrPtrInt16, int16_t*)
CapyDefArray(CapyArrPtrUInt16, uint16_t*)
CapyDefArray(CapyArrPtrInt32, int32_t*)
CapyDefArray(CapyArrPtrUInt32, uint32_t*)
CapyDefArray(CapyArrPtrInt64, int64_t*)
CapyDefArray(CapyArrPtrUInt64, uint64_t*)
CapyDefArray(CapyArrPtrFloat, float*)
CapyDefArray(CapyArrPtrDouble, double*)
