// ---------------------------- bresenham.h ---------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_BRESENHAM_H
#define CAPY_BRESENHAM_H
#include "externalHeaders.h"
#include "cext.h"

// Description:
// Bresenham class.

// Bresenham object
typedef struct CapyBresenham {

  // Current position
  int64_t* pos;

  // Start position (default: 0,0)
  int64_t* startPos;

  // End position (default: 1,1)
  int64_t* endPos;

  // Fields for the forEach macro
  int64_t* datatype;

  // Index in iteration
  size_t idx;

  // Internal variables of the Bresenham algorithm
  int64_t d[2], s[2], err[2];

  // Methods for the forEach macro
  int64_t** (*reset)(void);
  bool (*isActive)(void);
  int64_t** (*next)(void);

  // Destructor
  void (*destruct)(void);
} CapyBresenham;

// Create a CapyBresenham
// Output:
//   Return a CapyBresenham
CapyBresenham CapyBresenhamCreate(void);

// Allocate memory for a new CapyBresenham and create it
// Output:
//   Return a CapyBresenham
// Exception:
//   May raise CapyExc_MallocFailed.
CapyBresenham* CapyBresenhamAlloc(void);

// Free the memory used by a CapyBresenham* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyBresenham to free
void CapyBresenhamFree(CapyBresenham** const that);
#endif
