// ------------------------ burrowswheelertransform.h -----------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache info@baillehachepascal.dev
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_BURROWSWHEELERTRANSFORM_H
#define CAPY_BURROWSWHEELERTRANSFORM_H
#include "externalHeaders.h"
#include "cext.h"

// Description:
// BurrowsWheelerTransform class.

// Structure to memorise the transformed/untransformed data and its size in byte
typedef struct CapyBurrowsWheelerTransformData {

  // Bytes of data
  uint8_t* bytes;

  // Size in byte
  size_t size;

  // Index of the first byte in transformed data
  size_t idxFirstByte;
} CapyBurrowsWheelerTransformData;

// BurrowsWheelerTransform object
typedef struct CapyBurrowsWheelerTransform {

  // Destructor
  void (*destruct)(void);

  // Transform the data
  // Input:
  //   data: the data to transform
  // Output:
  //   Return the transformed data
  CapyBurrowsWheelerTransformData (*transform)(
    CapyBurrowsWheelerTransformData const data);

  // Untransform the data
  // Input:
  //   data: the data to untransform
  // Output:
  //   Return the untransformed data
  CapyBurrowsWheelerTransformData (*untransform)(
    CapyBurrowsWheelerTransformData const data);
} CapyBurrowsWheelerTransform;

// Create a CapyBurrowsWheelerTransform
// Output:
//   Return a CapyBurrowsWheelerTransform
CapyBurrowsWheelerTransform CapyBurrowsWheelerTransformCreate(void);

// Allocate memory for a new CapyBurrowsWheelerTransform and create it
// Output:
//   Return a CapyBurrowsWheelerTransform
// Exception:
//   May raise CapyExc_MallocFailed.
CapyBurrowsWheelerTransform* CapyBurrowsWheelerTransformAlloc(void);

// Free the memory used by a CapyBurrowsWheelerTransform* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyBurrowsWheelerTransform to free
void CapyBurrowsWheelerTransformFree(CapyBurrowsWheelerTransform** const that);
#endif
