// ---------------------------------- capy.h ----------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "capy.h"

// Getter for the version of the library
// Output:
//   Return the version as a char*
char const* CapyGetVersion(void) {

  // Return the macro VERSION defined in the Makefile, converted in a
  // char*
  return CAPY_MACRO_TO_STR(VERSION);
}

// Getter for the commit id of the library
// Output:
//   Return the commit id as a char*
char const* CapyGetCommitId(void) {

  // Return the macro COMMIT defined in the Makefile, converted in a
  // char*
  return CAPY_MACRO_TO_STR(COMMIT);
}

// Getter for the build mode of the library
// Output:
//   Return the build mode as an enum Capy_BuildMode
Capy_BuildMode CapyGetBuildMode(void) {

  // Return the macro BUILD_MODE defined in the Makefile
  return (Capy_BuildMode)BUILD_MODE;
}
