// ---------------------------------- capy.h ----------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_H
#define CAPY_H
#include "externalHeaders.h"
#include "cext.h"
#include "trycatch.h"
#include "color.h"
#include "strDecorator.h"
#include "array.h"
#include "list.h"
#include "image.h"
#include "range.h"
#include "displayMagnifier.h"
#include "display.h"
#include "argParser.h"
#include "streamIo.h"
#include "feistelCipher.h"
#include "elo.h"
#include "random.h"
#include "ratio.h"
#include "capymath.h"
#include "dict.h"
#include "mathfun.h"
#include "bezier.h"
#include "pen.h"
#include "diffevo.h"
#include "colorChart.h"
#include "colorCorrection.h"
#include "colorCorrectionMatrix.h"
#include "colorCorrectionBezier.h"
#include "colorHisto.h"
#include "comparator.h"
#include "sort.h"
#include "distribution.h"
#include "imgKernel.h"
#include "floodFill.h"
#include "geometricShape.h"
#include "colorPatch.h"
#include "graph.h"
#include "chrono.h"
#include "dataset.h"
#include "pointCloud.h"
#include "greedy.h"
#include "fileFormat.h"
#include "pngFormat.h"
#include "plyFormat.h"
#include "kmeans.h"
#include "frequentistHypothesisTesting.h"
#include "predictor.h"
#include "supportVectorMachine.h"
#include "memoryPool.h"
#include "kfoldCrossValid.h"
#include "gradientDescent.h"
#include "neuralNetwork.h"
#include "nnPredictor.h"
#include "slidingAverage.h"
#include "x11display.h"
#include "polynomial.h"
#include "fft.h"
#include "noise.h"
#include "bnoise.h"
#include "sampling.h"
#include "poissonSampling.h"
#include "idxCombination.h"
#include "bresenham.h"
#include "sdfcsg.h"
#include "quaternion.h"
#include "pathfinder.h"
#include "collisionDetection.h"
#include "hashFun.h"
#include "tree.h"
#include "minimax.h"
#include "lsystem.h"
#include "turtlegraphic.h"
#include "font.h"
#include "graphplotter.h"
#include "geomap.h"
#include "date.h"
#include "compressor.h"
#include "burrowswheelertransform.h"
#include "camera.h"
#include "lightray.h"
#include "galeshapleypairing.h"
#include "maze.h"
#include "btree.h"
#include "bitarray.h"
#include "voting.h"
#include "mirrorballcamera.h"
#include "rungekutta.h"
#include "rsacipher.h"
#include "markovdecisionprocess.h"
#include "policygradient.h"
#include "rulerandcompass.h"
#include "springmass.h"
#include "catmullromspline.h"
#include "hierarchicalclustering.h"
#include "verletintegration.h"

// Description:
// LibCapy related function and headers include.

// Build modes
typedef enum Capy_BuildMode {
  Capy_BuildMode_Development,
  Capy_BuildMode_Production,
} Capy_BuildMode;

// Getter for the version of the library
// Output:
//   Return the version as a char*
char const* CapyGetVersion(void);

// Getter for the commit id of the library
// Output:
//   Return the commit as a char*
char const* CapyGetCommitId(void);

// Getter for the build mode of the library
// Output:
//   Return the build mode as an enum Capy_BuildMode
Capy_BuildMode CapyGetBuildMode(void);
#endif
