// ------------------- colorCorrectionBezier.h --------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_COLORCORRBEZIER_H
#define CAPY_COLORCORRBEZIER_H
#include "externalHeaders.h"
#include "cext.h"
#include "colorChart.h"
#include "bezier.h"
#include "colorCorrection.h"

// Description:
// Color correction using bezier surface approximation.

// ColorCorrBezier object
typedef struct CapyColorCorrBezier {

  // Inherits CapyColorCorr
  CapyColorCorrDef;

  // Bezier surface used to perform the correction
  CapyBezier* bezier;

  // Order of the bezier surface, if it's equal to 0 when match() is called
  // the best order is automatically calculated (default value: 0)
  CapyBezierOrder_t order;
  CapyPad(CapyBezierOrder_t, order);

  // Number of anchor per axis to avoid divergence (default: 3)
  size_t nbAnchorPerAxis;

  // Destructor
  void (*destructCapyColorCorr)(void);
} CapyColorCorrBezier;

// Create a CapyColorCorrBezier
// Output:
//   Return a CapyColorCorrBezier
CapyColorCorrBezier CapyColorCorrBezierCreate(void);

// Allocate memory for a new CapyColorCorrBezier and create it
// Output:
//   Return a CapyColorCorrBezier
// Exception:
//   May raise CapyExc_MallocFailed.
CapyColorCorrBezier* CapyColorCorrBezierAlloc(void);

// Free the memory used by a CapyColorCorrBezier* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyColorCorrBezier to free
void CapyColorCorrBezierFree(CapyColorCorrBezier** const that);
#endif
