// ------------------- colorCorrectionMatrix.h --------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_COLORCORRMAT_H
#define CAPY_COLORCORRMAT_H
#include "externalHeaders.h"
#include "cext.h"
#include "colorChart.h"
#include "colorCorrection.h"

// Description:
// Color correction matrix algorithm.

// ColorCorrMat object
typedef struct CapyColorCorrMat {

  // Inherits CapyColorCorr
  CapyColorCorrDef;

  // Correction matrix (values ordered as [iRow*3+iCol])
  double mat[9];

  // Thresholds for the optimiser, default values are -0.001 and 100000
  double thresholdFitness;
  size_t thresholdIter;

  // Destructor
  void (*destructCapyColorCorr)(void);
} CapyColorCorrMat;

// Create a CapyColorCorrMat
// Output:
//   Return a CapyColorCorrMat
CapyColorCorrMat CapyColorCorrMatCreate(void);

// Allocate memory for a new CapyColorCorrMat and create it
// Output:
//   Return a CapyColorCorrMat
// Exception:
//   May raise CapyExc_MallocFailed.
CapyColorCorrMat* CapyColorCorrMatAlloc(void);

// Free the memory used by a CapyColorCorrMat* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyColorCorrMat to free
void CapyColorCorrMatFree(CapyColorCorrMat** const that);
#endif
