// ------------------------------ mathfun.c ------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "comparator.h"

// Compare the two given inputs.
// Input:
//   a: the first input
//   b: the second input
// Output:
//   Return an int, negative if a is 'before' b, 0 if a is 'same' as b,
//   positive if a is 'after' b.
static int Eval(
  void const* a,
  void const* b) {
  (void)a; (void)b;
  raiseExc(CapyExc_UndefinedExecution);
  assert (false && "MathComparator.eval not set in the inheriting class.");
}

// Free the memory used by a CapyComparator
static void Destruct(void) {
  return;
}

// Create a CapyComparator
// Output:
//   Return a CapyComparator
CapyComparator CapyComparatorCreate(void) {
  return (CapyComparator){
    .destruct = Destruct,
    .eval = Eval,
  };
}

// Comparators for string (comparator for numerical type are in capymath.c)
int CapyCmpStrInc(
  char const* a,
  char const* b) {
  return strcmp(a, b);
}

int CapyCmpStrDec(
  char const* a,
  char const* b) {
  return -1 * strcmp(a, b);
}

// Comparators for basic types
#define CapyComparatorBasicTypeDec(name)   \
CapyComparator capyComparator ## name =    \
  { .eval = (CapyCmpFun)CapyCmp ## name };
CapyComparatorBasicTypeDec(CharInc)
CapyComparatorBasicTypeDec(StrInc)
CapyComparatorBasicTypeDec(Int8Inc)
CapyComparatorBasicTypeDec(UInt8Inc)
CapyComparatorBasicTypeDec(Int16Inc)
CapyComparatorBasicTypeDec(UInt16Inc)
CapyComparatorBasicTypeDec(Int32Inc)
CapyComparatorBasicTypeDec(UInt32Inc)
CapyComparatorBasicTypeDec(Int64Inc)
CapyComparatorBasicTypeDec(UInt64Inc)
CapyComparatorBasicTypeDec(FloatInc)
CapyComparatorBasicTypeDec(DoubleInc)
CapyComparatorBasicTypeDec(SizeInc)
CapyComparatorBasicTypeDec(CharDec)
CapyComparatorBasicTypeDec(StrDec)
CapyComparatorBasicTypeDec(Int8Dec)
CapyComparatorBasicTypeDec(UInt8Dec)
CapyComparatorBasicTypeDec(Int16Dec)
CapyComparatorBasicTypeDec(UInt16Dec)
CapyComparatorBasicTypeDec(Int32Dec)
CapyComparatorBasicTypeDec(UInt32Dec)
CapyComparatorBasicTypeDec(Int64Dec)
CapyComparatorBasicTypeDec(UInt64Dec)
CapyComparatorBasicTypeDec(FloatDec)
CapyComparatorBasicTypeDec(DoubleDec)
