// ------------------------------- comparator.h ------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_COMPARATOR_H
#define CAPY_COMPARATOR_H
#include "externalHeaders.h"
#include "cext.h"
#include "capymath.h"

// Description:
// Comparator functions.

// Definition of a CapyComparator class
#define CapyComparatorDef struct { \
  void (*destruct)(void);          \
  CapyCmpFun eval;                 \
}

// CapyComparator class
typedef CapyComparatorDef CapyComparator;

// Create a CapyComparator
// Output:
//   Return a CapyComparator
CapyComparator CapyComparatorCreate(void);

// Comparator for string (comparator for numerical type are in capymath.h),
// increasing version
int CapyCmpStrInc(
  char const* a,
  char const* b);

// Comparator for string (comparator for numerical type are in capymath.h),
// decreasing version
int CapyCmpStrDec(
  char const* a,
  char const* b);

// Comparators for basic types
#define CapyComparatorBasicTypeDef(name)       \
extern CapyComparator capyComparator ## name;
CapyComparatorBasicTypeDef(CharInc)
CapyComparatorBasicTypeDef(StrInc)
CapyComparatorBasicTypeDef(Int8Inc)
CapyComparatorBasicTypeDef(UInt8Inc)
CapyComparatorBasicTypeDef(Int16Inc)
CapyComparatorBasicTypeDef(UInt16Inc)
CapyComparatorBasicTypeDef(Int32Inc)
CapyComparatorBasicTypeDef(UInt32Inc)
CapyComparatorBasicTypeDef(Int64Inc)
CapyComparatorBasicTypeDef(UInt64Inc)
CapyComparatorBasicTypeDef(FloatInc)
CapyComparatorBasicTypeDef(DoubleInc)
CapyComparatorBasicTypeDef(SizeInc)
CapyComparatorBasicTypeDef(CharDec)
CapyComparatorBasicTypeDef(StrDec)
CapyComparatorBasicTypeDef(Int8Dec)
CapyComparatorBasicTypeDef(UInt8Dec)
CapyComparatorBasicTypeDef(Int16Dec)
CapyComparatorBasicTypeDef(UInt16Dec)
CapyComparatorBasicTypeDef(Int32Dec)
CapyComparatorBasicTypeDef(UInt32Dec)
CapyComparatorBasicTypeDef(Int64Dec)
CapyComparatorBasicTypeDef(UInt64Dec)
CapyComparatorBasicTypeDef(FloatDec)
CapyComparatorBasicTypeDef(DoubleDec)
#endif
