// --------------------------------- dict.c ----------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "dict.h"

// Definition of dictionaries for some basic types
CapyDefDict(CapyDictChar, char)
CapyDefDict(CapyDictInt8, int8_t)
CapyDefDict(CapyDictUInt8, uint8_t)
CapyDefDict(CapyDictInt16, int16_t)
CapyDefDict(CapyDictUInt16, uint16_t)
CapyDefDict(CapyDictInt32, int32_t)
CapyDefDict(CapyDictUInt32, uint32_t)
CapyDefDict(CapyDictInt64, int64_t)
CapyDefDict(CapyDictUInt64, uint64_t)
CapyDefDict(CapyDictFloat, float)
CapyDefDict(CapyDictDouble, double)
CapyDefDict(CapyDictPtrChar, char*)
CapyDefDict(CapyDictPtrInt8, int8_t*)
CapyDefDict(CapyDictPtrUInt8, uint8_t*)
CapyDefDict(CapyDictPtrInt16, int16_t*)
CapyDefDict(CapyDictPtrUInt16, uint16_t*)
CapyDefDict(CapyDictPtrInt32, int32_t*)
CapyDefDict(CapyDictPtrUInt32, uint32_t*)
CapyDefDict(CapyDictPtrInt64, int64_t*)
CapyDefDict(CapyDictPtrUInt64, uint64_t*)
CapyDefDict(CapyDictPtrFloat, float*)
CapyDefDict(CapyDictPtrDouble, double*)
