// ---------------------------- externalHeaders.h -----------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <setjmp.h>
#include <string.h>
#include <stdint.h>
#include <assert.h>
#include <stdarg.h>
#include <math.h>
#include <float.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <errno.h>
#include <inttypes.h>
#include <semaphore.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/resource.h>
#include <sys/stat.h>
#pragma GCC diagnostic push 
#pragma GCC diagnostic ignored "-Wpadded"
#include <png.h>
#include <gtk/gtk.h>
#pragma GCC diagnostic pop
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <complex.h>
#if CAPY_ARCH_X86 == 1
#include <immintrin.h>
#include <locale.h>
#endif

// Description:
// Include all the standard librairies used in LibCapy.

// Typedef-ing struct timeval
typedef struct timeval Timeval;

// Typedef-ing struct timespec
typedef struct timespec Timespec;

// Typedef-ing struct stat
typedef struct stat FileStat;
