// ------------------- fileFormat.c --------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "fileFormat.h"

// Labels for supported file format
char const* capyFileFormatLbl[capyFileFormat_nb] = {
  ".png, Portable Netork Graphic",
  ".ply, Polygon File Format"
};

// Macros for the default method implementation
#define CapyFileFormatDefaultMethods(T)                  \
static Capy ## T* Load ## T(CapyStreamIo* const file) {  \
  (void)file;                                            \
  raiseExc(CapyExc_UnsupportedFormat);                   \
  return NULL;                                           \
}                                                        \
static void Save ## T(                                   \
  Capy ## T const* const obj,                            \
   CapyStreamIo* const file) {                           \
  (void)obj;                                             \
  (void)file;                                            \
  raiseExc(CapyExc_UnsupportedFormat);                   \
}

// Default method implementations
CapyFileFormatDefaultMethods(Img)
CapyFileFormatDefaultMethods(PointCloud)

// Free the memory used by a CapyFileFormat
static void Destruct(void) {
  return;
}

// Create a CapyFileFormat
// Input:
//   type: the type of the format
// Output:
//   Return a CapyFileFormat
CapyFileFormat CapyFileFormatCreate(CapyFileFormatType const type) {
  return (CapyFileFormat){
    .type = type,
    .lbl = capyFileFormatLbl[type],
    .destruct = Destruct,
    .loadImg = LoadImg,
    .saveImg = SaveImg,
    .loadPointCloud = LoadPointCloud,
    .savePointCloud = SavePointCloud,
  };
}
