// ---------------------------------- hashFun.h ---------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_HASHFUN_H
#define CAPY_HASHFUN_H
#include "externalHeaders.h"
#include "cext.h"

// Description:
// Hash function classes.

// CapyHashFun object definition macro
typedef uint64_t CapyHashFunValue_t;
#define CapyHashFunDef struct { \
  void (*destruct)(void);       \
  CapyHashFunValue_t (*eval)(   \
    char const* const data,     \
    size_t const sizeData);     \
}

// CapyHashFun object
typedef CapyHashFunDef CapyHashFun;

// Create a CapyHashFun
// Output:
//   Return a CapyHashFun
CapyHashFun CapyHashFunCreate(void);

// Allocate memory for a new CapyHashFun and create it
// Output:
//   Return a CapyHashFun
// Exception:
//   May raise CapyExc_MallocFailed.
CapyHashFun* CapyHashFunAlloc(void);

// Free the memory used by a CapyHashFun* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyHashFun to free
void CapyHashFunFree(CapyHashFun** const that);

// FNV1aHashFun object
typedef struct CapyFNV1aHashFun {

  // Inherit CapyHashFun
  CapyHashFunDef;

  // Prime
  CapyHashFunValue_t prime;

  // Offset
  CapyHashFunValue_t offset;

  // Destructor
  void (*destructCapyHashFun)(void);
} CapyFNV1aHashFun;

// Create a CapyFNV1aHashFun
// Output:
//   Return a CapyFNV1aHashFun
CapyFNV1aHashFun CapyFNV1aHashFunCreate(void);

// Allocate memory for a new CapyFNV1aHashFun and create it
// Output:
//   Return a CapyFNV1aHashFun
// Exception:
//   May raise CapyExc_MallocFailed.
CapyFNV1aHashFun* CapyFNV1aHashFunAlloc(void);

// Free the memory used by a CapyFNV1aHashFun* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyFNV1aHashFun to free
void CapyFNV1aHashFunFree(CapyFNV1aHashFun** const that);
#endif
