// ----------------------------- idxCombination.h ----------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_COMBINATOR_H
#define CAPY_COMBINATOR_H
#include "externalHeaders.h"
#include "cext.h"

// Description:
// Iterator on combination of indices.

// IdxCombination object
typedef struct CapyIdxCombination {

  // Dimension of the combination
  size_t dim;

  // Current indices
  size_t* indices;

  // Ranges for each indices (default: [0,1], inclusive)
  CapyRangeSize* ranges;

  // Fields for the forEach macro
  size_t* datatype;

  // Index in iteration
  size_t idx;

  // Methods for the forEach macro
  size_t** (*reset)(void);
  bool (*isActive)(void);
  size_t** (*next)(void);

  // Destructor
  void (*destruct)(void);
} CapyIdxCombination;

// Create a CapyIdxCombination
// Input:
//   dim: dimension of the combination
// Output:
//   Return a CapyIdxCombination
CapyIdxCombination CapyIdxCombinationCreate(size_t const dim);

// Allocate memory for a new CapyIdxCombination and create it
// Input:
//   dim: dimension of the combination
// Output:
//   Return a CapyIdxCombination
// Exception:
//   May raise CapyExc_MallocFailed.
CapyIdxCombination* CapyIdxCombinationAlloc(size_t const dim);

// Free the memory used by a CapyIdxCombination* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyIdxCombination to free
void CapyIdxCombinationFree(CapyIdxCombination** const that);
#endif
