// ------------------- plyFormat.h --------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_PLYFORMAT_H
#define CAPY_PLYFORMAT_H
#include "externalHeaders.h"
#include "cext.h"
#include "fileFormat.h"

// Description:
// Class to manipulate file in PLY format

// CapyPlyFormat class.
typedef struct CapyPlyFormat {

  // Parent class
  CapyFileFormatDef;

  // Flag to memorise if the file is in binary format (else it's in ascii
  // format). Updated when loading, used when saving.
  bool isBinary;
  CapyPad(bool, 1);

  // Destructor
  void (*destructCapyFileFormat)(void);
} CapyPlyFormat;

// Create a CapyPlyFormat
// Output:
//   Return a CapyPlyFormat
CapyPlyFormat CapyPlyFormatCreate(void);

// Allocate memory for a new CapyPlyFormat and create it
// Output:
//   Return a CapyPlyFormat
// Exception:
//   May raise CapyExc_MallocFailed.
CapyPlyFormat* CapyPlyFormatAlloc(void);

// Free the memory used by a CapyPlyFormat* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyPlyFormat to free
void CapyPlyFormatFree(CapyPlyFormat** const that);
#endif
