// ------------------- pngFormat.h --------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_PNGFORMAT_H
#define CAPY_PNGFORMAT_H
#include "externalHeaders.h"
#include "cext.h"
#include "fileFormat.h"

// Description:
// Class to manipulate file in PNG format

// CapyPngFormat class.
typedef struct CapyPngFormat {

  // Parent class
  CapyFileFormatDef;

  // Destructor
  void (*destructCapyFileFormat)(void);
} CapyPngFormat;

// Create a CapyPngFormat
// Output:
//   Return a CapyPngFormat
CapyPngFormat CapyPngFormatCreate(void);

// Allocate memory for a new CapyPngFormat and create it
// Output:
//   Return a CapyPngFormat
// Exception:
//   May raise CapyExc_MallocFailed.
CapyPngFormat* CapyPngFormatAlloc(void);

// Free the memory used by a CapyPngFormat
// Input:
//   that: the CapyPngFormat to free
void CapyPngFormatDestruct(CapyPngFormat* const that);

// Free the memory used by a CapyPngFormat* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyPngFormat to free
void CapyPngFormatFree(CapyPngFormat** const that);
#endif
