// -------------------------- poissonSampling.h ---------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_POISSON_DISK_SAMPLING_H
#define CAPY_POISSON_DISK_SAMPLING_H
#include "externalHeaders.h"
#include "cext.h"
#include "sampling.h"

// Description:
// Poisson disk sampling class.

// PoissonSampling object
typedef struct CapyPoissonSampling {

  // Inherits CapySampling
  CapySamplingDef;

  // Minimum distance between samples (default: 1.0)
  double r;

  // Threshold before rejection (default: 30)
  size_t k;

  // Destructor
  void (*destructCapySampling)(void);
} CapyPoissonSampling;

// Create a CapyPoissonSampling
// Input:
//   seed: seed for the random number generator
//    dim: dimension of the samples
// Output:
//   Return a CapyPoissonSampling
CapyPoissonSampling CapyPoissonSamplingCreate(
  CapyRandomSeed_t const seed,
            size_t const dim);

// Allocate memory for a new CapyPoissonSampling and create it
// Input:
//   seed: seed for the random number generator
//    dim: dimension of the samples
// Output:
//   Return a CapyPoissonSampling
// Exception:
//   May raise CapyExc_MallocFailed.
CapyPoissonSampling* CapyPoissonSamplingAlloc(
  CapyRandomSeed_t const seed,
            size_t const dim);

// Free the memory used by a CapyPoissonSampling* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyPoissonSampling to free
void CapyPoissonSamplingFree(CapyPoissonSampling** const that);
#endif
