// -------------------------------- polynomial.h -------------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_POLYNOMIAL_H
#define CAPY_POLYNOMIAL_H
#include "externalHeaders.h"
#include "cext.h"
#include "mathfun.h"
#include "capymath.h"

// Description:
// Polynomial class.

// 1D Polynomial object
typedef struct CapyPolynomial1D {

  // Inherits CapyMathFun
  struct CapyMathFunDef;

  // Coefficients of the polynomial in order x^0, x^1, x^2, ...
  CapyVec coeffs;

  // Destructor
  void (*destructCapyMathFun)(void);
} CapyPolynomial1D;

// Create a CapyPolynomial1D
// Input:
//   coeffs: the coefficients of the polynomial in order x^0, x^1, x^2, ...
// Output:
//   Return a CapyPolynomial1D
CapyPolynomial1D CapyPolynomial1DCreate(CapyVec const* const coeffs);

// Allocate memory for a new CapyPolynomial1D and create it
// Input:
//   coeffs: the coefficients of the polynomial in order x^0, x^1, x^2, ...
// Output:
//   Return a CapyPolynomial1D
// Exception:
//   May raise CapyExc_MallocFailed.
CapyPolynomial1D* CapyPolynomial1DAlloc(CapyVec const* const coeffs);

// Free the memory used by a CapyPolynomial1D* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapyPolynomial1D to free
void CapyPolynomial1DFree(CapyPolynomial1D** const that);
#endif
