// ------------------------------ slidingAverage.h -----------------------------
/*
    LibCapy - a general purpose library of C functions and data structures
    Copyright (C) 2021-2025 Pascal Baillehache baillehache.pascal@gmail.com
    https://baillehachepascal.dev
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CAPY_SLIDING_AVERAGE_H
#define CAPY_SLIDING_AVERAGE_H
#include "externalHeaders.h"
#include "cext.h"

// Description:
// Sliding average class.

// SlidingAverage object
typedef struct CapySlidingAverage {

  // Size of the sliding window
  size_t size;

  // Counter to memorise when the window is filled
  size_t counter;

  // Current average value
  double val;

  // Destructor
  void (*destruct)(void);

  // Update the average with a new value
  // Input:
  //   val: the new value
  // Output:
  //   Update the current average and counter
  void (*update)(double const val);
} CapySlidingAverage;

// Create a CapySlidingAverage
// Input:
//   size: the size of the sliding window
// Output:
//   Return a CapySlidingAverage
CapySlidingAverage CapySlidingAverageCreate(size_t const size);

// Allocate memory for a new CapySlidingAverage and create it
// Input:
//   size: the size of the sliding window
// Output:
//   Return a CapySlidingAverage
// Exception:
//   May raise CapyExc_MallocFailed.
CapySlidingAverage* CapySlidingAverageAlloc(size_t const size);

// Free the memory used by a CapySlidingAverage* and reset '*that' to NULL
// Input:
//   that: a pointer to the CapySlidingAverage to free
void CapySlidingAverageFree(CapySlidingAverage** const that);
#endif
