#include <math.h>
#include <assert.h>
#include "./bezierFun.c"
int main() {
  double check[25][3] = {
    {0.000000, 1.000000, 2.000000},
    {0.000000, 0.750000, 1.500000},
    {0.000000, 0.500000, 1.000000},
    {0.000000, 0.250000, 0.500000},
    {0.000000, 0.000000, 0.000000},
    {0.000000, 0.500000, 2.000000},
    {0.000000, 0.375000, 1.500000},
    {0.000000, 0.250000, 1.000000},
    {0.000000, 0.125000, 0.500000},
    {0.000000, 0.000000, 0.000000},
    {0.000000, 0.000000, 2.000000},
    {0.000000, 0.000000, 1.500000},
    {0.000000, 0.000000, 1.000000},
    {0.000000, 0.000000, 0.500000},
    {0.000000, 0.000000, 0.000000},
    {0.000000, -0.500000, 2.000000},
    {0.000000, -0.375000, 1.500000},
    {0.000000, -0.250000, 1.000000},
    {0.000000, -0.125000, 0.500000},
    {0.000000, 0.000000, 0.000000},
    {0.000000, -1.000000, 2.000000},
    {0.000000, -0.750000, 1.500000},
    {0.000000, -0.500000, 1.000000},
    {0.000000, -0.250000, 0.500000},
    {0.000000, 0.000000, 0.000000},
  };
  double in[2];
  double out[3];
  for(int i = 0; i < 5; ++i) for(int j = 0; j < 5; ++j) {
    in[0] = (double)i * 0.25;
    in[1] = (double)j * 0.25;
    bezier(in, out);
    for(int k = 0; k < 3; ++k) assert(fabs(check[i*5+j][k] - out[k]) < 1e-6);
  }
  return 0;
}
