#ifndef size_t
#include <stddef.h>
#endif
static void bezier(
  double const* const in,
  double* const out) {
  size_t idxCtrlLUT[4][2];
  idxCtrlLUT[0][0] = 0;
  idxCtrlLUT[0][1] = 0;
  idxCtrlLUT[1][0] = 1;
  idxCtrlLUT[1][1] = 0;
  idxCtrlLUT[2][0] = 0;
  idxCtrlLUT[2][1] = 1;
  idxCtrlLUT[3][0] = 1;
  idxCtrlLUT[3][1] = 1;
  double binomialLUT[4];
  binomialLUT[0] = 1.000000000000;
  binomialLUT[1] = 1.000000000000;
  binomialLUT[2] = 0.000000000000;
  binomialLUT[3] = 0.000000000000;
  double ctrls[4][3];
  ctrls[0][0] = 0.000000000000;
  ctrls[0][1] = 1.000000000000;
  ctrls[0][2] = 2.000000000000;
  ctrls[1][0] = 0.000000000000;
  ctrls[1][1] = -1.000000000000;
  ctrls[1][2] = 2.000000000000;
  ctrls[2][0] = 0.000000000000;
  ctrls[2][1] = 0.000000000000;
  ctrls[2][2] = 0.000000000000;
  ctrls[3][0] = 0.000000000000;
  ctrls[3][1] = 0.000000000000;
  ctrls[3][2] = 0.000000000000;
  double ctrlWeights[4];
  for(size_t iOut = 0; iOut < 3; ++iOut)
    out[iOut] = 0.0;
  for(size_t iCtrl = 0; iCtrl < 4;++iCtrl) {
    ctrlWeights[iCtrl] = 1.0;
    for(size_t iIn = 0; iIn < 2; ++iIn) {
      size_t jCtrl = idxCtrlLUT[iCtrl][iIn];
      double weight =
        binomialLUT[jCtrl] *
        pow(1.0 - in[iIn], 1 - jCtrl) *
        pow(in[iIn], jCtrl);
      ctrlWeights[iCtrl] *= weight;
    }
    for(size_t iOut = 0; iOut < 3; ++iOut) {
      out[iOut] += ctrlWeights[iCtrl] * ctrls[iCtrl][iOut];
    }
  }
}

