#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

// ReLU activation function
double abalonePredLayer001Activation(double const x) {
  if(x >= 0.0) return x; else return 0.0;
}

// ReLU activation function
double abalonePredLayer002Activation(double const x) {
  if(x >= 0.0) return x; else return 0.0;
}

// Neural network prediction
// Input:
// u: the predicted input, array of 8 double values as follow:
// u[0]: [Sex], encoded as [M]=0, [F]=1, [I]=2
// u[1]: [Length], trained on [0.075000000, 0.815000000]
// u[2]: [Diameter], trained on [0.055000000, 0.650000000]
// u[3]: [Height], trained on [0.000000000, 1.130000000]
// u[4]: [Whole_weight], trained on [0.002000000, 2.825500000]
// u[5]: [Shucked_weight], trained on [0.001000000, 1.488000000]
// u[6]: [Viscera_weight], trained on [0.000500000, 0.760000000]
// u[7]: [Shell_weight], trained on [0.001500000, 1.005000000]
// Output:
// Return the predicted value
double abalonePred(double const* const u) {
  double v[1] = {0.0};
  double w[8] = {};
  w[0] = (double)-0x1p+0 + (u[0] - (double)0x0p+0) * (double)0x1p+0;
  w[1] = (double)-0x1p+0 + (u[1] - (double)0x1.3333333333333p-4) * (double)0x1.59f22983759f2p+1;
  w[2] = (double)-0x1p+0 + (u[2] - (double)0x1.c28f5c28f5c29p-5) * (double)0x1.ae4089ae4089bp+1;
  w[3] = (double)-0x1p+0 + (u[3] - (double)0x0p+0) * (double)0x1.c518eb9c518ecp+0;
  w[4] = (double)-0x1p+0 + (u[4] - (double)0x1.0624dd2f1a9fcp-9) * (double)0x1.6aaba23febb0cp-1;
  w[5] = (double)-0x1p+0 + (u[5] - (double)0x1.0624dd2f1a9fcp-10) * (double)0x1.58514247f65bfp+0;
  w[6] = (double)-0x1p+0 + (u[6] - (double)0x1.0624dd2f1a9fcp-11) * (double)0x1.511058fc1faf1p+1;
  w[7] = (double)-0x1p+0 + (u[7] - (double)0x1.89374bc6a7efap-10) * (double)0x1.fe36d9189e2abp+0;
  static double node1[16] = {0};
  static double node2[8] = {0};
  node1[0] = abalonePredLayer001Activation((double)-0x1.33730565af9eap-1 + (double)0x1.dc111a80d6e1p-2 * w[0] + (double)-0x1.4ce9f260c9266p-1 * w[1] + (double)-0x1.2f84dbf7e7bd2p-1 * w[2] + (double)0x1.5caf2681c2771p-1 * w[3] + (double)0x1.27413b2eb7609p-1 * w[4] + (double)0x1.51a0f2e327f8cp-1 * w[5] + (double)0x1.2681e4f02ee6fp-1 * w[6] + (double)0x1.2736f296aaacdp-1 * w[7]);
  node1[1] = abalonePredLayer001Activation((double)-0x1.2ea1754bd69f1p-1 + (double)-0x1.2915166cd9b23p-1 * w[0] + (double)-0x1.f4d5ab207d4a7p-2 * w[1] + (double)-0x1.30a5bb97ffe5ap-1 * w[2] + (double)0x1.10231e78c6566p-1 * w[3] + (double)0x1.674d90405c086p-1 * w[4] + (double)0x1.3293cfe32d65dp-1 * w[5] + (double)0x1.31960e41c1a6dp-1 * w[6] + (double)0x1.449823cd46ad4p-1 * w[7]);
  node1[2] = abalonePredLayer001Activation((double)-0x1.337305648b423p-1 + (double)0x1.2827b62f0057cp-1 * w[0] + (double)-0x1.6229275f4164dp-1 * w[1] + (double)-0x1.1fc03582b112ap-1 * w[2] + (double)0x1.2ac1f311752d2p-1 * w[3] + (double)0x1.26fc4beedd874p-1 * w[4] + (double)0x1.227acb330b133p-1 * w[5] + (double)0x1.0eff98e23f499p-1 * w[6] + (double)0x1.4210adb86c0f5p-1 * w[7]);
  node1[3] = abalonePredLayer001Activation((double)-0x1.4552d5bf689f5p-1 + (double)0x1.06b44b5f0d5c2p-1 * w[0] + (double)-0x1.261fda38a73dcp-1 * w[1] + (double)-0x1.2949102ceeebbp-1 * w[2] + (double)0x1.46c5cc5749e98p-1 * w[3] + (double)-0x1.a0b80e32b4022p-2 * w[4] + (double)0x1.e2257ca98d531p-1 * w[5] + (double)0x1.203f1a2e70e51p+0 * w[6] + (double)-0x1.1ffe96e9bd573p-2 * w[7]);
  node1[4] = abalonePredLayer001Activation((double)0x1.2a9dcfc7769fp-3 + (double)0x1.d750b23c63855p-3 * w[0] + (double)0x1.468207819239p-3 * w[1] + (double)0x1.4ff9650644b74p-2 * w[2] + (double)0x1.9f0fa8def21a2p-11 * w[3] + (double)0x1.35967436b0f7ep-3 * w[4] + (double)-0x1.6a6c377731a1p-2 * w[5] + (double)-0x1.55684ca34283ep-4 * w[6] + (double)0x1.11a812d22bd1cp-2 * w[7]);
  node1[5] = abalonePredLayer001Activation((double)-0x1.d37544e29fb3fp-1 + (double)0x1.e8d18fe997d53p-3 * w[0] + (double)-0x1.cb07f5b03967ep-3 * w[1] + (double)-0x1.1cf89b1c7c8c7p-2 * w[2] + (double)0x1.a72afd9cd5531p-6 * w[3] + (double)0x1.3500129fda2ccp-3 * w[4] + (double)0x1.c4626954972f7p-2 * w[5] + (double)0x1.6d2dd517540ap-2 * w[6] + (double)0x1.460ae627f3bc6p-1 * w[7]);
  node1[6] = abalonePredLayer001Activation((double)-0x1.333ba39b2ca4cp-1 + (double)0x1.135c00753dc7fp-1 * w[0] + (double)-0x1.5408490690f36p-1 * w[1] + (double)-0x1.220f4abe1087p-1 * w[2] + (double)0x1.ca2af0fb53bfcp-2 * w[3] + (double)0x1.54f2686e12c23p-1 * w[4] + (double)0x1.4319a9c2d77eap-1 * w[5] + (double)0x1.12dc7565ce354p-1 * w[6] + (double)0x1.6419c478f3481p-1 * w[7]);
  node1[7] = abalonePredLayer001Activation((double)0x1.0c30b3e2a860fp-2 + (double)0x1.a1ca3fd1f66dep-2 * w[0] + (double)0x1.994f0c3565be2p-2 * w[1] + (double)0x1.4cbe8c1641537p-1 * w[2] + (double)-0x1.6d33a4867fbbcp-3 * w[3] + (double)0x1.77a34747af422p-4 * w[4] + (double)-0x1.6faef4831438dp-3 * w[5] + (double)-0x1.094edde8aafd5p-3 * w[6] + (double)0x1.b41c13ee05fa7p-3 * w[7]);
  node1[8] = abalonePredLayer001Activation((double)0x1.187e4b9ba3b27p-1 + (double)-0x1.33a7197467b25p-2 * w[0] + (double)0x1.aa49f3715088ep-1 * w[1] + (double)0x1.1bb4555d3db93p+0 * w[2] + (double)-0x1.8524b8c3fdf3p-2 * w[3] + (double)0x1.44456dc92dcb5p-4 * w[4] + (double)-0x1.df4aa967e2d2ap-1 * w[5] + (double)-0x1.3359b61961c0cp-2 * w[6] + (double)0x1.d6385f58a1322p-2 * w[7]);
  node1[9] = abalonePredLayer001Activation((double)-0x1.47386e59f0e8dp-1 + (double)0x1.029c94c68d29ep-1 * w[0] + (double)-0x1.e02dd2791ef3cp-2 * w[1] + (double)-0x1.1c10fffea3376p-1 * w[2] + (double)0x1.5f945f8a6d188p-1 * w[3] + (double)-0x1.a383b27035817p-2 * w[4] + (double)0x1.8f5b812576d07p-1 * w[5] + (double)0x1.e1cbd7f04d26fp-1 * w[6] + (double)-0x1.3d84ae70d1d59p-6 * w[7]);
  node1[10] = abalonePredLayer001Activation((double)-0x1.337304db5f3a8p-1 + (double)0x1.cee006ef3e3f2p-2 * w[0] + (double)-0x1.28413f89f5a3fp-1 * w[1] + (double)-0x1.377498a3f7bcep-1 * w[2] + (double)0x1.51fa3ff1c8c5dp-1 * w[3] + (double)0x1.2137c26f8fe9ep-1 * w[4] + (double)0x1.3bc89357b8d05p-1 * w[5] + (double)0x1.2115becd9cf09p-1 * w[6] + (double)0x1.4cbffd5dba11fp-1 * w[7]);
  node1[11] = abalonePredLayer001Activation((double)0x1.08f3ed0a05c06p-1 + (double)-0x1.c68fd889a8cf9p-3 * w[0] + (double)0x1.91262ee1f469cp-1 * w[1] + (double)0x1.1ae4b49ab38a7p+0 * w[2] + (double)-0x1.c321fea46a141p-2 * w[3] + (double)-0x1.0832850b660f6p-6 * w[4] + (double)-0x1.af89f9b0da9c2p-1 * w[5] + (double)-0x1.9f0ebaa70e624p-2 * w[6] + (double)0x1.ba7b2614ba9dcp-2 * w[7]);
  node1[12] = abalonePredLayer001Activation((double)-0x1.c97c31e8456bap-1 + (double)0x1.aa29c41f2c39ep-5 * w[0] + (double)-0x1.610a0f11fedc3p-1 * w[1] + (double)-0x1.4dfe2dcc508c3p-3 * w[2] + (double)0x1.98b88790b039ep-1 * w[3] + (double)0x1.e9e149bff1c72p-3 * w[4] + (double)0x1.50d768bb7f209p-3 * w[5] + (double)0x1.a1cdb19b0349ap-2 * w[6] + (double)0x1.f13d7e9968ec5p-1 * w[7]);
  node1[13] = abalonePredLayer001Activation((double)-0x1.3373053f0fddcp-1 + (double)0x1.28e1b13403c1fp-1 * w[0] + (double)-0x1.6458d929f7ec6p-1 * w[1] + (double)-0x1.3a7947f4caecap-1 * w[2] + (double)0x1.113ab4616f68dp-1 * w[3] + (double)0x1.3ad27b2bdece3p-1 * w[4] + (double)0x1.ffe7288dafd5bp-2 * w[5] + (double)0x1.3d6a3148706d8p-1 * w[6] + (double)0x1.697961ee1feeap-1 * w[7]);
  node1[14] = abalonePredLayer001Activation((double)0x1.8a886baa4a5eap-2 + (double)0x1.de34f9e568548p-3 * w[0] + (double)0x1.9673f9e50687dp-1 * w[1] + (double)0x1.067a76c15fd31p+0 * w[2] + (double)-0x1.1241e7d1aa764p-2 * w[3] + (double)0x1.2f9a8a787ec24p-2 * w[4] + (double)-0x1.8a72fe941e735p-2 * w[5] + (double)0x1.e08deeae0c388p-4 * w[6] + (double)0x1.1e6ede253ca3ap-1 * w[7]);
  node1[15] = abalonePredLayer001Activation((double)-0x1.094a45f5d31fap-1 + (double)0x1.19e918b1f2cc8p-2 * w[0] + (double)-0x1.712ba57122201p-4 * w[1] + (double)-0x1.99b277ad39597p-4 * w[2] + (double)0x1.4713dd06c0e9cp-1 * w[3] + (double)0x1.69b3638d783f4p-1 * w[4] + (double)0x1.a13b262bc34a3p-3 * w[5] + (double)0x1.9a038b86f9155p-1 * w[6] + (double)0x1.30e5bd4c2e97bp+0 * w[7]);
  node2[0] = abalonePredLayer002Activation((double)0x1.f17cff0be7244p-1 + (double)0x1.69dceba3677dap-1 * node1[0] + (double)0x1.9fdcea7e58cdcp-2 * node1[1] + (double)0x1.734c3dc3172f5p-1 * node1[2] + (double)-0x1.38adcffd109c3p-1 * node1[3] + (double)0x1.8d340fd5c4a3p-2 * node1[4] + (double)-0x1.8806839aab538p-2 * node1[5] + (double)0x1.1d4c0f65c351ep-1 * node1[6] + (double)0x1.19eed12f79f9p-2 * node1[7] + (double)0x1.454ba60aa449bp-3 * node1[8] + (double)-0x1.860558efbeaefp-2 * node1[9] + (double)0x1.9df436c9f94dap-2 * node1[10] + (double)0x1.bf6418070432ap-2 * node1[11] + (double)0x1.82bcd18a214a4p-5 * node1[12] + (double)0x1.111d5bab3aca5p-1 * node1[13] + (double)-0x1.6c0abd02e70d5p-7 * node1[14] + (double)0x1.67aaf5e0b83dap-4 * node1[15]);
  node2[1] = abalonePredLayer002Activation((double)0x1.f24c16aecc5c4p-1 + (double)0x1.5507c1a735529p-1 * node1[0] + (double)0x1.1001b540726c1p-1 * node1[1] + (double)0x1.7b6b6d04934a9p-2 * node1[2] + (double)0x1.10f84d4d7ccd2p-1 * node1[3] + (double)-0x1.636d08fe90101p-4 * node1[4] + (double)-0x1.3edc76cfff056p-2 * node1[5] + (double)0x1.0166fe9365c51p-1 * node1[6] + (double)-0x1.2daecc57463a2p-5 * node1[7] + (double)0x1.4cff621a3bc24p-1 * node1[8] + (double)0x1.fc99f2f3b6bb5p-2 * node1[9] + (double)0x1.4505d0f217a6bp-1 * node1[10] + (double)0x1.aa359c0d0c53bp-2 * node1[11] + (double)-0x1.5beab9d4cdff3p-2 * node1[12] + (double)0x1.aedc6bf5a7424p-2 * node1[13] + (double)0x1.724144d3b55f1p-2 * node1[14] + (double)0x1.3dac7dc4c6933p-6 * node1[15]);
  node2[2] = abalonePredLayer002Activation((double)-0x1.80a78675770c3p-3 + (double)-0x1.f51eb06358ff7p-7 * node1[0] + (double)0x1.a7c4a1264af65p-2 * node1[1] + (double)-0x1.93adf7f0bb6d4p-3 * node1[2] + (double)-0x1.1b7d723f086bep-1 * node1[3] + (double)-0x1.6005b209ee9f2p-1 * node1[4] + (double)0x1.db9d942742a0ap-3 * node1[5] + (double)0x1.37065b5d456ffp-1 * node1[6] + (double)-0x1.27b09814b02b8p-1 * node1[7] + (double)-0x1.add10941d716p-2 * node1[8] + (double)-0x1.61b6282b2513cp-1 * node1[9] + (double)-0x1.83cd1ef9cbcf3p-5 * node1[10] + (double)-0x1.10462766ae1e6p-1 * node1[11] + (double)0x1.7651f29c691f5p-5 * node1[12] + (double)0x1.728812f629f5p-3 * node1[13] + (double)-0x1.56af1fd413315p-2 * node1[14] + (double)-0x1.63a57b6b13ac3p-5 * node1[15]);
  node2[3] = abalonePredLayer002Activation((double)-0x1.3373057a431e5p-1 + (double)-0x1.b42fa35b4bdd3p-2 * node1[0] + (double)-0x1.0a652ab2c2d1cp-1 * node1[1] + (double)-0x1.ec4489eedb228p-2 * node1[2] + (double)-0x1.24594d0209e0dp-1 * node1[3] + (double)-0x1.32a494d903b43p-1 * node1[4] + (double)-0x1.11750bf21c086p-3 * node1[5] + (double)-0x1.d279064418ca3p-2 * node1[6] + (double)-0x1.62a5f0cba1e62p-1 * node1[7] + (double)-0x1.62bfc94641899p-1 * node1[8] + (double)-0x1.9ece94fd2d93p-1 * node1[9] + (double)-0x1.56feb9abf8e6bp-1 * node1[10] + (double)-0x1.41814010e5e3ap-1 * node1[11] + (double)-0x1.73cc081f57ae7p-1 * node1[12] + (double)-0x1.1ec34031a0e82p-1 * node1[13] + (double)-0x1.4b24f46e411e1p-1 * node1[14] + (double)-0x1.7c4493dfaf46ap-1 * node1[15]);
  node2[4] = abalonePredLayer002Activation((double)-0x1.337305769ee59p-1 + (double)-0x1.c595af6b75cb6p-3 * node1[0] + (double)-0x1.423f5f169afc5p-1 * node1[1] + (double)-0x1.3606393549593p-1 * node1[2] + (double)-0x1.b8f6cb24b7c3p-2 * node1[3] + (double)-0x1.34f85e97e0824p-1 * node1[4] + (double)0x1.e16d3633ee094p-4 * node1[5] + (double)-0x1.101babef462b8p-1 * node1[6] + (double)-0x1.3c001f6eb5017p-1 * node1[7] + (double)-0x1.04cab5efbb43ap-1 * node1[8] + (double)-0x1.0153c2e1ebb73p-1 * node1[9] + (double)-0x1.30cfa9694fe45p-1 * node1[10] + (double)-0x1.4f87136a1c907p-1 * node1[11] + (double)-0x1.9733460173c82p-2 * node1[12] + (double)-0x1.f1838cff0bb48p-2 * node1[13] + (double)-0x1.383a5ee2bc913p-1 * node1[14] + (double)-0x1.fc7824d67fb16p-2 * node1[15]);
  node2[5] = abalonePredLayer002Activation((double)-0x1.3373055f40699p-1 + (double)-0x1.8b1a9cc677ae3p-1 * node1[0] + (double)-0x1.e4ba33383a575p-2 * node1[1] + (double)-0x1.1295fedb3f10ep-1 * node1[2] + (double)-0x1.2800b289f583ep-1 * node1[3] + (double)-0x1.1feca659b1a8fp-5 * node1[4] + (double)-0x1.10d1ce4782e53p-5 * node1[5] + (double)-0x1.33c91c2bc83ep-1 * node1[6] + (double)0x1.49e073a9fa33p-6 * node1[7] + (double)-0x1.ccd72bba07a4fp-2 * node1[8] + (double)-0x1.188f56e38c14fp-1 * node1[9] + (double)-0x1.0c30c8263a267p-1 * node1[10] + (double)-0x1.950c33fefa238p-1 * node1[11] + (double)-0x1.4618acbf1a90ep-1 * node1[12] + (double)-0x1.6b5b0908a260ap-1 * node1[13] + (double)-0x1.4fc36c648d08dp-1 * node1[14] + (double)-0x1.b12f650385533p-7 * node1[15]);
  node2[6] = abalonePredLayer002Activation((double)-0x1.3373057885c1dp-1 + (double)-0x1.45cf65394f422p-2 * node1[0] + (double)-0x1.112f47fed8637p-1 * node1[1] + (double)-0x1.fa4b3c5983ddep-2 * node1[2] + (double)-0x1.b97b0b5eb7515p-2 * node1[3] + (double)-0x1.35bbed05fd9e5p-1 * node1[4] + (double)-0x1.35783069d15bbp-6 * node1[5] + (double)-0x1.932b01b9bc30ep-2 * node1[6] + (double)-0x1.57f1e9ecf8cf1p-1 * node1[7] + (double)-0x1.ad2f69c160fcfp-1 * node1[8] + (double)-0x1.ec5e53983e5f2p-2 * node1[9] + (double)-0x1.f158f4d7c3a35p-2 * node1[10] + (double)-0x1.2a191e308a77fp-1 * node1[11] + (double)-0x1.1ca6147fc3837p-1 * node1[12] + (double)-0x1.69c58ca2e065bp-1 * node1[13] + (double)-0x1.d056da0c33a0cp-2 * node1[14] + (double)-0x1.27e5cfe9483d7p-1 * node1[15]);
  node2[7] = abalonePredLayer002Activation((double)-0x1.3373045cde95ep-1 + (double)-0x1.474166672dde5p-1 * node1[0] + (double)-0x1.ece9d8236ab2fp-2 * node1[1] + (double)-0x1.1224e61313cb4p-1 * node1[2] + (double)-0x1.0ebe5dde1af23p-1 * node1[3] + (double)-0x1.6347baae850dbp-1 * node1[4] + (double)0x1.e743339781c75p-4 * node1[5] + (double)-0x1.4c9f9dceb873dp-1 * node1[6] + (double)-0x1.541d749b649d6p-4 * node1[7] + (double)-0x1.8de1d2d11ae59p-1 * node1[8] + (double)-0x1.614dd49f34c32p-2 * node1[9] + (double)-0x1.cc17fa00deb23p-2 * node1[10] + (double)-0x1.c0be41237f353p-1 * node1[11] + (double)-0x1.10e465d1ea069p-1 * node1[12] + (double)-0x1.21d65cb6801bcp-1 * node1[13] + (double)-0x1.bd4b968b74329p-2 * node1[14] + (double)-0x1.3e171ba5e8cf5p-1 * node1[15]);
  v[0] = (double)0x1.15e237652c6d7p+0 + (double)0x1.619854d8cb74p+0 * node2[0] + (double)0x1.ebab864a43f0ep+0 * node2[1] + (double)-0x1.e7c780389aa7bp-2 * node2[2] + (double)-0x1.a569205e46c62p-1 * node2[3] + (double)-0x1.0bf2023613475p-3 * node2[4] + (double)-0x1.92a716c944f52p-1 * node2[5] + (double)-0x1.9cad0c35a842dp-3 * node2[6] + (double)0x1.04817972738ebp-1 * node2[7];
  return v[0];
}

// Driver function
int main(int argc, char** argv) {
  if(argc != 9) {
    printf("Expect 8 arguments\n");
    return 1;
  }
  double u[8] = {0};
  double v[1] = {0};
  if(strcmp(argv[1], "M") == 0) u[0] = 0.0;
  if(strcmp(argv[1], "F") == 0) u[0] = 1.0;
  if(strcmp(argv[1], "I") == 0) u[0] = 2.0;
  u[1] = atof(argv[2]);
  u[2] = atof(argv[3]);
  u[3] = atof(argv[4]);
  u[4] = atof(argv[5]);
  u[5] = atof(argv[6]);
  u[6] = atof(argv[7]);
  u[7] = atof(argv[8]);

  v[0] = abalonePred(u);
  printf("%lf\n", v[0]);
  return 0;
}

