#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

// SiLU activation function
double IrisPredLayer001Activation(double const x) {
  return x / (1.0 + exp(-x));
}

// Neural network prediction
// Input:
// u: the predicted input, array of 4 double values as follow:
// u[0]: [sepallength], trained on [4.300000000, 7.900000000]
// u[1]: [sepalwidth], trained on [2.000000000, 4.400000000]
// u[2]: [petallength], trained on [1.000000000, 6.900000000]
// u[3]: [petalwidth], trained on [0.100000000, 2.500000000]
// v: the result of prediction, array of 3 double values in [-1,1]
//    representing the confidence (higher is more confident) that
//    [class] is:
// v[0]: [Iris-setosa]
// v[1]: [Iris-versicolor]
// v[2]: [Iris-virginica]
// Output:
// Return argmax(v), the index of the predicted value
int IrisPred(double const* const u, double* const v) {
  double w[4] = {};
  w[0] = (double)0x0p+0 + (u[0] - (double)0x1.1333333333333p+2) * (double)0x1.1c71c71c71c71p-2;
  w[1] = (double)0x0p+0 + (u[1] - (double)0x1p+1) * (double)0x1.aaaaaaaaaaaaap-2;
  w[2] = (double)0x0p+0 + (u[2] - (double)0x1p+0) * (double)0x1.5b1e5f75270dp-3;
  w[3] = (double)0x0p+0 + (u[3] - (double)0x1.999999999999ap-4) * (double)0x1.aaaaaaaaaaaabp-2;
  static double node1[8] = {0};
  node1[0] = IrisPredLayer001Activation((double)0x1.1712ebfc17603p-2 + (double)-0x1.d6e615325db65p-8 * w[0] + (double)-0x1.0578b7d5ef8b6p-5 * w[1] + (double)0x1.25ea55d69b2fep-1 * w[2] + (double)-0x1.b7b8ba559511p-4 * w[3]);
  node1[1] = IrisPredLayer001Activation((double)-0x1.1613f81a1f1f7p-1 + (double)-0x1.1c297d3d02c02p-3 * w[0] + (double)-0x1.edcd7ac1c70edp-2 * w[1] + (double)0x1.16bf81306887ap-11 * w[2] + (double)-0x1.0d5dd59ddbf38p-4 * w[3]);
  node1[2] = IrisPredLayer001Activation((double)-0x1.4fa53a84bd3d8p-1 + (double)-0x1.3cb5dccad8384p+0 * w[0] + (double)-0x1.6fc75f1760e0ap-1 * w[1] + (double)0x1.64100d865cb8ap-1 * w[2] + (double)0x1.064117765a957p-1 * w[3]);
  node1[3] = IrisPredLayer001Activation((double)0x1.651dea200e2d6p-8 + (double)0x1.2ef3e4fce4c2dp-3 * w[0] + (double)-0x1.e91312233da4p-4 * w[1] + (double)-0x1.1e720cbd07bd4p-1 * w[2] + (double)-0x1.7c8cfee00716cp-1 * w[3]);
  node1[4] = IrisPredLayer001Activation((double)0x1.114b434764dcbp+0 + (double)-0x1.0bb83c933721p-2 * w[0] + (double)0x1.77712d94ef925p-2 * w[1] + (double)-0x1.4af75884185c9p+1 * w[2] + (double)-0x1.77d78a145408dp+0 * w[3]);
  node1[5] = IrisPredLayer001Activation((double)-0x1.969015d3d072cp-7 + (double)0x1.4630e0a9ebd99p-3 * w[0] + (double)-0x1.66e54d5ca3213p-1 * w[1] + (double)0x1.d814df45cee5fp-3 * w[2] + (double)0x1.aaca4ec7287e6p-3 * w[3]);
  node1[6] = IrisPredLayer001Activation((double)-0x1.878a51b15370fp-3 + (double)-0x1.4dacef4fc7c2fp-2 * w[0] + (double)-0x1.a612ae118d408p-1 * w[1] + (double)-0x1.2a3e54b903a9ep-8 * w[2] + (double)-0x1.7f7ecf5a0e27ap-1 * w[3]);
  node1[7] = IrisPredLayer001Activation((double)-0x1.36994af89b2a1p+0 + (double)-0x1.1ef89ccb07e71p-1 * w[0] + (double)-0x1.3803214755fc3p-1 * w[1] + (double)0x1.34de775cf8a2ap+1 * w[2] + (double)0x1.b3112f442bbe8p+0 * w[3]);
  v[0] = (double)0x1.3402aa7567558p-1 + (double)-0x1.299d7807ea435p-3 * node1[0] + (double)0x1.2f010fcd0d66bp-1 * node1[1] + (double)-0x1.b3fd116aece4cp-3 * node1[2] + (double)0x1.55b0836a14d9bp+0 * node1[3] + (double)0x1.62abab726e7f5p-1 * node1[4] + (double)-0x1.38ce9e18dd336p-1 * node1[5] + (double)-0x1.33112fee3ec19p-3 * node1[6] + (double)0x1.f61a2cd1b4db6p-5 * node1[7];
  v[1] = (double)0x1.a7600754b7021p-2 + (double)0x1.926e6e2b2f94fp-2 * node1[0] + (double)-0x1.9ad11bfb8dca9p-4 * node1[1] + (double)-0x1.2ff22a96807f6p+0 * node1[2] + (double)-0x1.7811f70a138d1p-1 * node1[3] + (double)-0x1.58f423cfbcdabp+0 * node1[4] + (double)0x1.15824846c8f58p-2 * node1[5] + (double)0x1.5a21f95d2477p-1 * node1[6] + (double)-0x1.e948d4de29b3ep-1 * node1[7];
  v[2] = (double)0x1.3335910d51b62p-3 + (double)0x1.6af16e93a8c96p-2 * node1[0] + (double)-0x1.4ad05d8519fc3p-4 * node1[1] + (double)0x1.969003d3c3ac5p+0 * node1[2] + (double)-0x1.2ffeaaabf3f6ap-1 * node1[3] + (double)0x1.461d67b0e5b02p-1 * node1[4] + (double)-0x1.61e1082620983p-3 * node1[5] + (double)0x1.b6b416cfe12c6p-3 * node1[6] + (double)0x1.c455e521405a4p-1 * node1[7];
  double norm = 0.0;
  for(int i = 0; i < 3; ++i) norm += v[i] * v[i];
  norm = 1.0 / sqrt(norm);
  for(int i = 0; i < 3; ++i) v[i] *= norm;
  int pred = 0;
  for(int i = 1; i < 3; ++i) if(v[pred] < v[i]) pred = i;
  return pred;
}

// Driver function
int main(int argc, char** argv) {
  if(argc != 5) {
    printf("Expect 4 arguments\n");
    return 1;
  }
  double u[4] = {0};
  double v[3] = {0};
  u[0] = atof(argv[1]);
  u[1] = atof(argv[2]);
  u[2] = atof(argv[3]);
  u[3] = atof(argv[4]);

  int pred = IrisPred(u, v);
  char* predVal[3] = {
    "Iris-setosa",
    "Iris-versicolor",
    "Iris-virginica",
  };
  printf("%s\n", predVal[pred]);
  return 0;
}

