#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

// Gaussian (radial basis) kernel
double IrisPredKernel(double const* const u, double const* const v, size_t const n) {
  double x = 0.0;
  for(size_t i = 0; i < n; ++i) {
    double y = u[i] - v[i];
    x += y * y;
  }
  double z = exp(-1.0 * 10.000000 * x);
  return z;
}

// Support vector machine prediction
// Input:
// u: the predicted input, array of 4 double values as follow:
// u[0]: [sepallength], trained on [4.300000000, 7.900000000]
// u[1]: [sepalwidth], trained on [2.000000000, 4.400000000]
// u[2]: [petallength], trained on [1.000000000, 6.900000000]
// u[3]: [petalwidth], trained on [0.100000000, 2.500000000]
// Output:
// Return a positive value if the predicted category [class] for the given
// input is [Iris-versicolor], else return a negative value. The larger the absolute
// value of the returned value, the more confident the prediction is.
int IrisPred(double const* const u) {
  double const support[16][5] = {
    {0x1.c71c71c71c722p-5, 0x1.ffffffffffff9p-4, 0x1.a08ad8f2fba94p-5, 0x1.5555555555555p-4, -0x1p+0},
    {0x1.471c71c71c71bp-1, 0x1.7fffffffffffep-2, 0x1.386822b63cbeep-1, 0x1p-1, 0x1p+0},
    {0x1.8e38e38e38e3ap-3, 0x0p+0, 0x1.b1e5f75270d04p-2, 0x1.8p-2, 0x1p+0},
    {0x1.0e38e38e38e39p-1, 0x1.555555555555ap-4, 0x1.2fba9386822b6p-1, 0x1.2aaaaaaaaaaabp-1, 0x1p+0},
    {0x1.c71c71c71c71ep-2, 0x1p-1, 0x1.49c34115b1e5fp-1, 0x1.6aaaaaaaaaaabp-1, 0x1p+0},
    {0x1.1c71c71c71c71p-1, 0x1.aaaaaaaaaaaaap-3, 0x1.5270d0456c798p-1, 0x1.2aaaaaaaaaaabp-1, 0x1p+0},
    {0x1.5555555555555p-1, 0x1.aaaaaaaaaaaaap-2, 0x1.5b1e5f75270dp-1, 0x1.5555555555555p-1, 0x1p+0},
    {0x1.e38e38e38e38ep-2, 0x1.2aaaaaaaaaaabp-2, 0x1.63cbeea4e1a08p-1, 0x1.4p-1, 0x1p+0},
    {0x1.555555555555ap-3, 0x1.aaaaaaaaaaaaap-3, 0x1.2fba9386822b6p-1, 0x1.5555555555555p-1, -0x1p+0},
    {0x1.38e38e38e38e3p-1, 0x1p-1, 0x1.63cbeea4e1a08p-1, 0x1.9555555555555p-1, -0x1p+0},
    {0x1.e38e38e38e38ep-2, 0x1.555555555555ap-4, 0x1.5b1e5f75270dp-1, 0x1.2aaaaaaaaaaabp-1, -0x1p+0},
    {0x1.1c71c71c71c71p-1, 0x1.2aaaaaaaaaaabp-2, 0x1.5270d0456c798p-1, 0x1.6aaaaaaaaaaabp-1, -0x1p+0},
    {0x1.9c71c71c71c72p-1, 0x1.aaaaaaaaaaaaap-2, 0x1.a08ad8f2fba93p-1, 0x1.4p-1, -0x1p+0},
    {0x1.1c71c71c71c71p-1, 0x1.5555555555553p-2, 0x1.63cbeea4e1a08p-1, 0x1.2aaaaaaaaaaabp-1, -0x1p+0},
    {0x1.e38e38e38e38ep-2, 0x1.aaaaaaaaaaaaap-2, 0x1.49c34115b1e5fp-1, 0x1.6aaaaaaaaaaabp-1, -0x1p+0},
    {0x1.c71c71c71c71ep-2, 0x1.aaaaaaaaaaaaap-2, 0x1.63cbeea4e1a08p-1, 0x1.6aaaaaaaaaaabp-1, -0x1p+0},
  };
  double const lambda[16] = {0x1.9ac06eaf95e4p-1, 0x1.ba1227f4789d3p+2, 0x1.5f58f1fddff6p+1, 0x1.80d398ee1eb5cp+3, 0x1.98b2bf7c5ab8ep+5, 0x1.c755d18355f0cp+4, 0x1.a4673ec422481p+5, 0x1.9p+6, 0x1.5f4db6b565d51p+2, 0x1.68b9f29e929fcp+3, 0x1.248182bc1308bp+5, 0x1.12cc73f9aa916p+4, 0x1.0e9cca1e8ac92p+3, 0x1.849f49414f8b4p+6, 0x1.eae41ddeff256p+5, 0x1.eff332038f001p+3};
  double w[4] = {};
  w[0] = (double)0x0p+0 + (u[0] - (double)0x1.1333333333333p+2) * (double)0x1.1c71c71c71c71p-2;
  w[1] = (double)0x0p+0 + (u[1] - (double)0x1p+1) * (double)0x1.aaaaaaaaaaaaap-2;
  w[2] = (double)0x0p+0 + (u[2] - (double)0x1p+0) * (double)0x1.5b1e5f75270dp-3;
  w[3] = (double)0x0p+0 + (u[3] - (double)0x1.999999999999ap-4) * (double)0x1.aaaaaaaaaaaabp-2;
  double x = 0.0;
  for(int i = 0; i < 16; ++i) {
    x += lambda[i] * support[i][4] * IrisPredKernel(support[i], w, 4);
  }
  x -= (double)0x1.9a7c8daaec0dcp-2;
  return x;
}

// Driver function
int main(int argc, char** argv) {
  if(argc != 5) {
    printf("Expect 4 arguments\n");
    return 1;
  }
  double u[4] = {};
  u[0] = atof(argv[1]);
  u[1] = atof(argv[2]);
  u[2] = atof(argv[3]);
  u[3] = atof(argv[4]);

  double pred = IrisPred(u);
  printf("%s\n", pred > 0.0 ? "Iris-versicolor" : "Iris-setosa");
  return 0;
}

