#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

// Gaussian (radial basis) kernel
double IrisPredKernel(double const* const u, double const* const v, size_t const n) {
  double x = 0.0;
  for(size_t i = 0; i < n; ++i) {
    double y = u[i] - v[i];
    x += y * y;
  }
  double z = exp(-1.0 * 10.000000 * x);
  return z;
}

// Support vector machine prediction
// Input:
// u: the predicted input, array of 4 double values as follow:
// u[0]: [sepallength], trained on [4.300000000, 7.900000000]
// u[1]: [sepalwidth], trained on [2.000000000, 4.400000000]
// u[2]: [petallength], trained on [1.000000000, 6.900000000]
// u[3]: [petalwidth], trained on [0.100000000, 2.500000000]
// Output:
// Return a positive value if the predicted category [class] for the given
// input is [Iris-versicolor], else return a negative value. The larger the absolute
// value of the returned value, the more confident the prediction is.
int IrisPred(double const* const u) {
  double const support[69][5] = {
    {-0x1.e38e38e38e38cp-1, -0x1.0000000000004p-2, -0x1.ba9386822b63dp-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.5555555555553p-1, -0x1.5555555555558p-4, -0x1.a9386822b63ccp-1, -0x1p+0, -0x1p+0},
    {-0x1p+0, -0x1.5555555555558p-3, -0x1.eea4e1a08ad8fp-1, -0x1p+0, -0x1p+0},
    {-0x1.5555555555558p-3, 0x1.5555555555554p-1, -0x1.dd49c34115b1ep-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.c71c71c71c718p-3, 0x1p+0, -0x1.a9386822b63ccp-1, -0x1.8p-1, -0x1p+0},
    {-0x1.c71c71c71c718p-3, 0x1.ffffffffffff8p-2, -0x1.86822b63cbeeap-1, -0x1.aaaaaaaaaaaabp-1, -0x1p+0},
    {-0x1.8e38e38e38e36p-2, 0x1.555555555555p-3, -0x1.86822b63cbeeap-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.aaaaaaaaaaaacp-1, 0x1.5555555555554p-2, -0x1p+0, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.1c71c71c71c74p-1, 0x1.555555555554p-4, -0x1.86822b63cbeeap-1, -0x1.5555555555555p-1, -0x1p+0},
    {-0x1.71c71c71c71c8p-1, 0x1.555555555555p-3, -0x1.63cbeea4e1a09p-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.38e38e38e38e3p-1, -0x1.5555555555558p-3, -0x1.97dd49c34115bp-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.ffffffffffffep-2, 0x1.7fffffffffffcp-1, -0x1.a9386822b63ccp-1, -0x1p+0, -0x1p+0},
    {-0x1.5555555555556p-2, 0x1.ffffffffffff8p-3, -0x1.cbeea4e1a08aep-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.c71c71c71c71cp-1, -0x1.8000000000002p-1, -0x1.cbeea4e1a08aep-1, -0x1.aaaaaaaaaaaabp-1, -0x1p+0},
    {-0x1.e38e38e38e38cp-1, 0x0p+0, -0x1.cbeea4e1a08aep-1, -0x1.d555555555555p-1, -0x1p+0},
    {-0x1.38e38e38e38e3p-1, 0x1.ffffffffffff8p-3, -0x1.97dd49c34115bp-1, -0x1.2aaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.1c71c71c71c74p-1, 0x1.ffffffffffff8p-2, -0x1.63cbeea4e1a09p-1, -0x1.8p-1, -0x1p+0},
    {0x1.ffffffffffffcp-2, 0x0p+0, 0x1.0456c797dd49cp-2, 0x1.555555555555p-4, 0x1p+0},
    {-0x1.5555555555556p-2, -0x1.8000000000002p-1, 0x1.15b1e5f7527p-6, 0x0p+0, 0x1p+0},
    {0x1.c71c71c71c718p-3, -0x1.555555555555ap-2, 0x1.c34115b1e5f7p-3, 0x1.5555555555558p-3, 0x1p+0},
    {0x1.c71c71c71c71p-4, 0x1.555555555554p-4, 0x1.0456c797dd49cp-2, 0x1p-2, 0x1p+0},
    {-0x1.5555555555553p-1, -0x1.5555555555556p-1, -0x1.c34115b1e5f78p-3, -0x1p-2, 0x1p+0},
    {0x1.1c71c71c71c6cp-2, -0x1.0000000000004p-2, 0x1.c34115b1e5f7p-3, 0x0p+0, 0x1p+0},
    {-0x1.ffffffffffffep-2, -0x1.aaaaaaaaaaaaap-2, -0x1.15b1e5f75272p-6, 0x1.555555555555p-4, 0x1p+0},
    {-0x1.38e38e38e38e3p-1, -0x1p+0, -0x1.386822b63cbfp-3, -0x1p-2, 0x1p+0},
    {-0x1.c71c71c71c72p-5, -0x1.aaaaaaaaaaaaap-1, 0x1.15b1e5f7527p-6, -0x1p-2, 0x1p+0},
    {-0x1p-52, -0x1.0000000000004p-2, 0x1.0456c797dd49cp-2, 0x1.555555555555p-4, 0x1p+0},
    {-0x1.1c71c71c71c76p-2, -0x1.0000000000004p-2, -0x1.e5f75270d0458p-4, 0x0p+0, 0x1p+0},
    {-0x1.5555555555558p-3, -0x1.aaaaaaaaaaaaap-2, 0x1.a08ad8f2fba8p-5, -0x1p-2, 0x1p+0},
    {0x1.c71c71c71c72p-5, -0x1.aaaaaaaaaaaaap-1, 0x1.7dd49c34115bp-3, 0x1.5555555555558p-3, 0x1p+0},
    {-0x1.c71c71c71c71p-4, 0x0p+0, 0x1.270d0456c797cp-2, 0x1.aaaaaaaaaaaacp-2, 0x1p+0},
    {0x1.c71c71c71c71p-4, -0x1.2aaaaaaaaaaabp-1, 0x1.49c34115b1e6p-2, 0x1.5555555555558p-3, 0x1p+0},
    {-0x1p-52, -0x1.555555555555ap-2, 0x1.0456c797dd49cp-2, -0x1.5555555555558p-4, 0x1p+0},
    {0x1.8e38e38e38e34p-2, -0x1.555555555555ap-2, 0x1.270d0456c797cp-2, 0x1.555555555555p-4, 0x1p+0},
    {0x1.5555555555554p-2, -0x1.5555555555558p-3, 0x1.6c797dd49c34p-2, 0x1.5555555555554p-2, 0x1p+0},
    {-0x1.c71c71c71c718p-3, -0x1p-1, -0x1.386822b63cbfp-3, -0x1p-2, 0x1p+0},
    {-0x1.c71c71c71c72p-5, -0x1.aaaaaaaaaaaaap-2, 0x1.8f2fba938682p-2, 0x1p-2, 0x1p+0},
    {-0x1.8e38e38e38e36p-2, -0x1.5555555555558p-3, 0x1.7dd49c34115bp-3, 0x1.5555555555558p-3, 0x1p+0},
    {-0x1.1c71c71c71c74p-1, -0x1.2aaaaaaaaaaabp-1, -0x1.49c34115b1e6p-2, -0x1.5555555555554p-3, 0x1p+0},
    {0x1.c71c71c71c71p-4, 0x1.555555555554p-4, 0x1.63cbeea4e1a08p-1, 0x1p+0, -0x1p+0},
    {-0x1.5555555555558p-3, -0x1.aaaaaaaaaaaaap-2, 0x1.8f2fba938682p-2, 0x1p-1, -0x1p+0},
    {0x1.1c71c71c71c6ep-1, -0x1.5555555555558p-3, 0x1.5270d0456c798p-1, 0x1.5555555555556p-1, -0x1p+0},
    {0x1.aaaaaaaaaaaa8p-1, -0x1.5555555555558p-3, 0x1.cbeea4e1a08acp-1, 0x1.5555555555556p-1, -0x1p+0},
    {-0x1.5555555555553p-1, -0x1.2aaaaaaaaaaabp-1, 0x1.7dd49c34115bp-3, 0x1.5555555555554p-2, -0x1p+0},
    {0x1.5555555555554p-2, -0x1.2aaaaaaaaaaabp-1, 0x1.4115b1e5f7526p-1, 0x1.aaaaaaaaaaaacp-2, -0x1p+0},
    {0x1.38e38e38e38e4p-1, 0x1.5555555555554p-2, 0x1.75270d0456c78p-1, 0x1p+0, -0x1p+0},
    {0x1.c71c71c71c718p-3, 0x0p+0, 0x1.8f2fba938682p-2, 0x1.2aaaaaaaaaaaap-1, -0x1p+0},
    {0x1.8e38e38e38e34p-2, -0x1.5555555555558p-3, 0x1.0d0456c797dd4p-1, 0x1.5555555555556p-1, -0x1p+0},
    {-0x1.c71c71c71c718p-3, -0x1.2aaaaaaaaaaabp-1, 0x1.6c797dd49c34p-2, 0x1.2aaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.5555555555558p-3, -0x1.555555555555ap-2, 0x1.8f2fba938682p-2, 0x1.d555555555554p-1, -0x1p+0},
    {0x1.c71c71c71c71cp-1, 0x1.ffffffffffff8p-2, 0x1.dd49c34115b1ep-1, 0x1.8000000000002p-1, -0x1p+0},
    {0x1.c71c71c71c71cp-1, -0x1p-1, 0x1p+0, 0x1.aaaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.c71c71c71c72p-5, -0x1.aaaaaaaaaaaaap-1, 0x1.6c797dd49c34p-2, 0x1.5555555555558p-3, -0x1p+0},
    {0x1.c71c71c71c71cp-1, -0x1.555555555555ap-2, 0x1.dd49c34115b1ep-1, 0x1.2aaaaaaaaaaaap-1, -0x1p+0},
    {0x1.c71c71c71c71p-4, -0x1.aaaaaaaaaaaaap-2, 0x1.49c34115b1e6p-2, 0x1.aaaaaaaaaaaacp-2, -0x1p+0},
    {0x1.38e38e38e38e4p-1, 0x0p+0, 0x1.63cbeea4e1a08p-1, 0x1.aaaaaaaaaaaacp-2, -0x1p+0},
    {0x1.38e38e38e38e4p-1, -0x1.5555555555558p-3, 0x1.4115b1e5f7526p-1, 0x1p-2, -0x1p+0},
    {0x1p+0, 0x1.ffffffffffff8p-2, 0x1.a9386822b63ccp-1, 0x1.2aaaaaaaaaaaap-1, -0x1p+0},
    {0x1.c71c71c71c71p-4, -0x1.555555555555ap-2, 0x1.8f2fba938682p-2, 0x1.5555555555558p-3, -0x1p+0},
    {-0x1p-52, -0x1p-1, 0x1.1e5f75270d044p-1, 0x1.555555555555p-4, -0x1p+0},
    {0x1.c71c71c71c71cp-1, -0x1.5555555555558p-3, 0x1.75270d0456c78p-1, 0x1.aaaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.c71c71c71c72p-5, -0x1.5555555555558p-3, 0x1.270d0456c797cp-2, 0x1.aaaaaaaaaaaacp-2, -0x1p+0},
    {0x1.c71c71c71c71cp-2, -0x1.5555555555558p-4, 0x1.f75270d0456c8p-2, 0x1.5555555555556p-1, -0x1p+0},
    {0x1.c71c71c71c71cp-2, -0x1.5555555555558p-4, 0x1.8f2fba938682p-2, 0x1.aaaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.5555555555558p-3, -0x1.aaaaaaaaaaaaap-2, 0x1.8f2fba938682p-2, 0x1p-1, -0x1p+0},
    {0x1.5555555555554p-2, 0x1.555555555554p-4, 0x1.2fba9386822b6p-1, 0x1p+0, -0x1p+0},
    {0x1.c71c71c71c71p-4, -0x1.2aaaaaaaaaaabp-1, 0x1.6c797dd49c34p-2, 0x1p-1, -0x1p+0},
    {0x1.c71c71c71c72p-5, 0x1.555555555555p-3, 0x1.f75270d0456c8p-2, 0x1.aaaaaaaaaaaaap-1, -0x1p+0},
    {-0x1.c71c71c71c71p-4, -0x1.5555555555558p-3, 0x1.8f2fba938682p-2, 0x1.aaaaaaaaaaaacp-2, -0x1p+0},
  };
  double const lambda[69] = {0x1.a12299ea9fbfp-4, 0x1.033a4ffec492p-12, 0x1.91ee64291d6aep-2, 0x1.035afeb1e268ap-2, 0x1.d5c77541d244cp-2, 0x1.4894a0698e4bfp-3, 0x1.46b504d9b83f5p-4, 0x1.9c7f088985b1p-2, 0x1.2da2383caf3e9p-4, 0x1.218701135db1bp-3, 0x1.69a6231c5544ap-2, 0x1.5d6eafdd28f7ep-2, 0x1.f565ac5ebde97p-3, 0x1.1c5f9804d034bp-1, 0x1.376b480fbf8cp-8, 0x1.277ac844b0001p-2, 0x1.720d653938d91p-3, 0x1.c29f12e4091acp-2, 0x1.1d95bd68534ddp-1, 0x1.ba64b1073f1fep+0, 0x1.dd47e0ea2d3c8p-4, 0x1.d3efa7bd7860ap-2, 0x1.e47c3d4c0d492p-3, 0x1.a0754de87617bp-1, 0x1.1db8d51f4936fp+0, 0x1.d97e8404f97fdp-1, 0x1.d9ec759e232e4p+0, 0x1.b740c18ed0e23p-2, 0x1.ab6565e61ba93p-3, 0x1.4b8ab81fd2aabp+1, 0x1.44218ea86f695p+2, 0x1.b5ed1f0e247p+0, 0x1.bdd539e065334p-2, 0x1.a9e40086f8dd6p-1, 0x1.b28806429fc03p+1, 0x1.022c8af41ee32p-1, 0x1.e2df89298f28p+2, 0x1.506bdfa27d489p-2, 0x1.40bd9615ef332p-1, 0x1.6bea1fea42dfp-2, 0x1.c4943342a30eep-1, 0x1.8b8d79a08adb1p-5, 0x1.0f508e4819e54p-7, 0x1.a349695e8918cp-1, 0x1.9c8b5f2b8b84ep-3, 0x1.eaf8762611396p-2, 0x1.22162399ca373p+0, 0x1.c25c138daf9cp-11, 0x1.48de11431d663p-3, 0x1.7acf52259e29p-3, 0x1.190a8cec4ea12p-2, 0x1.aa9c8c77526f4p-2, 0x1.b8b38b0a29f56p+1, 0x1.f9ff948655a29p-3, 0x1.ae86e67cd3d91p-1, 0x1.343abe439da3bp-4, 0x1.13099c7caf7a2p+0, 0x1.92b4dd57ee5cbp-2, 0x1.02c9bc30a8735p+3, 0x1.4fa4ae330129ep+0, 0x1.7896d4d863cf1p-2, 0x1.0cfd879fe260ap+2, 0x1.9d9778b3b702ep-2, 0x1.6de88010ba848p-9, 0x1.085a5323708p-11, 0x1.a0ddab3dd10a4p-6, 0x1.98f0a06761bp-1, 0x1.ab1bd910ed45ep-3, 0x1.6da69c3121555p+0};
  double w[4] = {};
  w[0] = (double)-0x1p+0 + (u[0] - (double)0x1.1333333333333p+2) * (double)0x1.1c71c71c71c71p-1;
  w[1] = (double)-0x1p+0 + (u[1] - (double)0x1p+1) * (double)0x1.aaaaaaaaaaaaap-1;
  w[2] = (double)-0x1p+0 + (u[2] - (double)0x1p+0) * (double)0x1.5b1e5f75270dp-2;
  w[3] = (double)-0x1p+0 + (u[3] - (double)0x1.999999999999ap-4) * (double)0x1.aaaaaaaaaaaabp-1;
  double x = 0.0;
  for(int i = 0; i < 69; ++i) {
    x += lambda[i] * support[i][4] * IrisPredKernel(support[i], w, 4);
  }
  x -= (double)0x1.b277b7c37b33p-2;
  return x;
}

// Driver function
int main(int argc, char** argv) {
  if(argc != 5) {
    printf("Expect 4 arguments\n");
    return 1;
  }
  double u[4] = {};
  u[0] = atof(argv[1]);
  u[1] = atof(argv[2]);
  u[2] = atof(argv[3]);
  u[3] = atof(argv[4]);

  double pred = IrisPred(u);
  printf("%s\n", pred > 0.0 ? "Iris-versicolor" : "Iris-setosa");
  return 0;
}

