#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  uint8_t a;
} Dummy;

CapyDecSizedArray(Array5UInt8, uint8_t, 5)
CapyDefSizedArray(Array5UInt8, uint8_t, 5)
CapyDecArray(ArrayDummy, Dummy)
CapyDefArray(ArrayDummy, Dummy)
static int DummyCmp(
  void const* a,
  void const* b) {
  if(((Dummy*)a)->a > ((Dummy*)b)->a) return 1;
  else if(((Dummy*)a)->a < ((Dummy*)b)->a) return -1;
  else return 0;
}

#endif
CUTEST(test001, "Creation/destruction of a sized generic array") {
  Array5UInt8* arr = Array5UInt8Alloc();
  CUTEST_ASSERT(arr, "array unallocated");
  Array5UInt8Free(&arr);
  CUTEST_ASSERT(arr == false, "array not reset to null");
}

CUTEST(test002, "(sized array) getSize") {
  Array5UInt8* arr = Array5UInt8Alloc();
  size_t size = $(arr, getSize)();
  CUTEST_ASSERT(size == 5, "size invalid (%ld)", size);
  Array5UInt8Free(&arr);
}

CUTEST(test003, "(sized array) get/set") {
  Array5UInt8* arr = Array5UInt8Alloc();
  loop(i, 5) {
    uint8_t n = (uint8_t)i;
    $(arr, set)((size_t)i, &n);
    uint8_t val = $(arr, get)((size_t)i);
    CUTEST_ASSERT(val == i, "set/get failed (%u != %u)", val, i);
  }
  Array5UInt8Free(&arr);
}

CUTEST(test004, "(sized array) getPtr") {
  Array5UInt8* arr = Array5UInt8Alloc();
  uint8_t n = 0;
  $(arr, set)(0, &n);
  uint8_t val = $(arr, get)(0);
  CUTEST_ASSERT(val == 0, "set failed (%u != 0)", val);
  uint8_t* ptr = $(arr, getPtr)(0);
  *ptr = 1;
  val = $(arr, get)(0);
  CUTEST_ASSERT(val == 1, "getPtr/set failed (%u != 1)", val);
  Array5UInt8Free(&arr);
}

CUTEST(test005, "(sized array) clone") {
  Array5UInt8* arr = Array5UInt8Alloc();
  loop(i, (uint8_t)5) {
    uint8_t n = (uint8_t)i;
    $(arr, set)((size_t)i, &n);
  }
  Array5UInt8* clone = $(arr, clone)();
  loop(i, 5) {
    uint8_t n = $(clone, get)((size_t)i);
    CUTEST_ASSERT(n == i, "clone failed (%u != %u)", n, i);
  }
  Array5UInt8Free(&clone);
  Array5UInt8Free(&arr);
}

CUTEST(test006, "(sized array) shuffle/sort") {
  Array5UInt8* arr = Array5UInt8Alloc();
  loop(i, 5) {
    uint8_t n = (uint8_t)i;
    $(arr, set)((size_t)i, &n);
  }
  CapyRandom rng = CapyRandomCreate(1);
  $(arr, shuffle)(&rng);
  $(&rng, destruct)();
  uint8_t check[5] = {3, 2, 1, 0, 4};
  loop(i, 5) {
    uint8_t n = $(arr, get)((size_t)i);
    CUTEST_ASSERT(
      n == check[i], "shuffle failed ([%d]=%u != %u)", i, n, check[i]);
  }
  $(arr, qsort)((CapyComparator*)&capyComparatorUInt8Inc);
  loop(i, 5) {
    uint8_t n = $(arr, get)((size_t)i);
    CUTEST_ASSERT(n == i, "sort failed ([%d]=%u != %u)", i, n, i);
  }
  Array5UInt8Free(&arr);
}

CUTEST(test007, "(sized array) iterator") {
  Array5UInt8* arr = Array5UInt8Alloc();
  forEach(val, arr->iter) {
    *valPtr = (uint8_t)(arr->iter.idx);
  }
  loop(i, 5) {
    uint8_t n = $(arr, get)((size_t)i);
    CUTEST_ASSERT(n == i, "iterator failed ([%d]=%u != %u)", i, n, i);
  }
  Array5UInt8Free(&arr);
}

CUTEST(test008, "(sized array) search") {
  Array5UInt8* arr = Array5UInt8Alloc();
  forEach(val, arr->iter) *valPtr = (uint8_t)(arr->iter.idx * 2);
  bool check = true;
  CapyComparator cmp = {.eval = (CapyCmpFun)CapyCmpUInt8Inc};
  loop(i, (size_t)5) {
    uint8_t val = (uint8_t)(i * 2);
    size_t idx = $(arr, search)(&val, &cmp);
    check &= (idx == i);
  }
  CUTEST_ASSERT(check, "search failed");
  Array5UInt8Free(&arr);
}

CUTEST(test201, "Creation/destruction of a generic array") {
  ArrayDummy* arr = ArrayDummyAlloc(1);
  CUTEST_ASSERT(arr, "array unallocated");
  ArrayDummyFree(&arr);
  CUTEST_ASSERT(arr == false, "array not reset to null");
}

CUTEST(test202, "(unsized array) getSize/resize") {
  ArrayDummy* arr = ArrayDummyAlloc(1);
  size_t size = $(arr, getSize)();
  CUTEST_ASSERT(size == 1, "size invalid (%ld)", size);
  $(arr, resize)(2);
  size = $(arr, getSize)();
  CUTEST_ASSERT(size == 2, "resize failed (%ld)", size);
  ArrayDummyFree(&arr);
}

CUTEST(test203, "(unsized array) get/set") {
  ArrayDummy* arr = ArrayDummyAlloc(2);
  Dummy vals[2] = {{.a = 0}, {.a = 1}};
  loop(i, (uint8_t)2) {
    $(arr, set)((size_t)i, vals + i);
    Dummy val = $(arr, get)((size_t)i);
    CUTEST_ASSERT(val.a == i, "set/get failed (%u != %u)", val.a, i);
  }
  ArrayDummyFree(&arr);
}

CUTEST(test204, "(unsized array) getPtr") {
  ArrayDummy* arr = ArrayDummyAlloc(1);
  Dummy dummy = {.a = 0};
  $(arr, set)(0, &dummy);
  Dummy val = $(arr, get)(0);
  CUTEST_ASSERT(val.a == 0, "set failed (%u != 0)", val.a);
  Dummy* ptr = $(arr, getPtr)(0);
  ptr->a = 1;
  val = $(arr, get)(0);
  CUTEST_ASSERT(val.a == 1, "getPtr/set failed (%u != 1)", val.a);
  ArrayDummyFree(&arr);
}

CUTEST(test205, "(unsized array) clone") {
  ArrayDummy* arr = ArrayDummyAlloc(5);
  loop(i, 5) {
    Dummy d = {.a = (uint8_t)i};
    $(arr, set)((size_t)i, &d);
  }
  ArrayDummy* clone = $(arr, clone)();
  loop(i, 5) {
    Dummy d = $(clone, get)((size_t)i);
    CUTEST_ASSERT(d.a == i, "clone failed (%u != %u)", d.a, i);
  }
  ArrayDummyFree(&clone);
  ArrayDummyFree(&arr);
}

CUTEST(test206, "(unsized array) shuffle/sort") {
  ArrayDummy* arr = ArrayDummyAlloc(5);
  loop(i, 5) {
    Dummy d = {.a = (uint8_t)i};
    $(arr, set)((size_t)i, &d);
  }
  CapyRandom rng = CapyRandomCreate(1);
  $(arr, shuffle)(&rng);
  $(&rng, destruct)();
  uint8_t check[5] = {3, 2, 1, 0, 4};
  loop(i, 5) {
    Dummy d = $(arr, get)((size_t)i);
    CUTEST_ASSERT(
      d.a == check[i], "shuffle failed ([%d]=%u != %u)", i, d.a, check[i]);
  }
  CapyComparator cmp = {.eval = DummyCmp};
  $(arr, qsort)(&cmp);
  loop(i, 5) {
    Dummy d = $(arr, get)((size_t)i);
    CUTEST_ASSERT(d.a == i, "sort failed ([%d]%u != %u)", i, d.a, i);
  }
  ArrayDummyFree(&arr);
}

CUTEST(test207, "(unsized array) iterator") {
  ArrayDummy* arr = ArrayDummyAlloc(5);
  forEach(val, arr->iter) {
    valPtr->a = (uint8_t)(arr->iter.idx);
  }
  loop(i, 5) {
    Dummy d = $(arr, get)((size_t)i);
    CUTEST_ASSERT(d.a == i, "iterator failed ([%d]=%u != %u)", i, d.a, i);
  }
  ArrayDummyFree(&arr);
}

CUTEST(test208, "(unsized array) search (1)") {
  ArrayDummy* arr = ArrayDummyAlloc(5);
  forEach(val, arr->iter) valPtr->a = (uint8_t)(arr->iter.idx * 2);
  bool check = true;
  CapyComparator cmp = {.eval = DummyCmp};
  loop(i, (size_t)5) {
    Dummy val = {.a = (uint8_t)(i * 2)};
    size_t idx = $(arr, search)(&val, &cmp);
    check &= (idx == i);
  }
  CUTEST_ASSERT(check, "search failed");
  ArrayDummyFree(&arr);
}

CUTEST(test209, "(unsized array) search (2)") {
  ArrayDummy* arr = ArrayDummyAlloc(6);
  forEach(val, arr->iter) valPtr->a = (uint8_t)(arr->iter.idx * 2);
  bool check = true;
  CapyComparator cmp = {.eval = DummyCmp};
  loop(i, (size_t)6) {
    Dummy val = {.a = (uint8_t)(i * 2)};
    size_t idx = $(arr, search)(&val, &cmp);
    check &= (idx == i);
  }
  CUTEST_ASSERT(check, "search failed");
  ArrayDummyFree(&arr);
}

CUTEST(test210, "(unsized array) search (3)") {
  ArrayDummy* arr = ArrayDummyAlloc(6);
  forEach(val, arr->iter) valPtr->a = (uint8_t)(arr->iter.idx * 2 + 1);
  bool check = true;
  CapyComparator cmp = {.eval = DummyCmp};
  Dummy val = {.a = 0};
  try {
    size_t idx = $(arr, search)(&val, &cmp);
    (void)idx;
    check &= false;
  } catch(CapyExc_InvalidElemIdx) {
    check &= true;
  } catchDefault {
    check &= false;
  } endCatch;
  val.a = 2;
  try {
    size_t idx = $(arr, search)(&val, &cmp);
    (void)idx;
    check &= false;
  } catch(CapyExc_InvalidElemIdx) {
    check &= true;
  } catchDefault {
    check &= false;
  } endCatch;
  val.a = 20;
  try {
    size_t idx = $(arr, search)(&val, &cmp);
    (void)idx;
    check &= false;
  } catch(CapyExc_InvalidElemIdx) {
    check &= true;
  } catchDefault {
    check &= false;
  } endCatch;
  CUTEST_ASSERT(check, "search failed");
  ArrayDummyFree(&arr);
}
