#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "BitArray alloc/free") {
  CapyBitArray* arr = CapyBitArrayAlloc();
  CUTEST_ASSERT(
    arr != NULL && arr->size == 0 && arr->data == NULL,
    "alloc failed");
  CapyBitArrayFree(&arr);
}

CUTEST(test002, "BitArray initialised from an array of bytes") {
  CapyBitArray* arr = CapyBitArrayAlloc();
  char const* const bytes = "hello world";
  $(arr, set)((uint8_t const*)bytes, strlen(bytes) + 1);
  CUTEST_ASSERT(
    arr->size == (8 * (strlen(bytes) + 1)) &&
    memcmp(arr->data, bytes, strlen(bytes) + 1) == 0,
    "initialisation failed");
  CapyBitArrayFree(&arr);
}

CUTEST(test003, "Get the bits") {
  CapyBitArray* arr = CapyBitArrayAlloc();
  uint8_t const bytes[2] = {0xfa, 0xaf};
  $(arr, set)(bytes, 2);
  bool isOk = true;
  loop(iByte, 2) loop(iBit, 8) {
    bool bit = $(arr, getBit)((size_t)(iBit + iByte * 8));
    isOk &= (bit == ((bytes[iByte] >> (7 - iBit)) & 1));
  }
  CUTEST_ASSERT(isOk, "get bits failed");
  CapyBitArrayFree(&arr);
}

CUTEST(test004, "Resize the array") {
  CapyBitArray* arr = CapyBitArrayAlloc();
  $(arr, resize)(16);
  CUTEST_ASSERT(arr->size == 16 && arr->data != NULL, "resize failed");
  CapyBitArrayFree(&arr);
}

CUTEST(test005, "Set the bits") {
  CapyBitArray* arr = CapyBitArrayAlloc();
  $(arr, resize)(16);
  uint8_t const bytes[2] = {0xfa, 0xaf};
  loop(iByte, 2) loop(iBit, 8) {
    bool bit = ((bytes[iByte] >> (7 - iBit)) & 1);
    $(arr, setBit)((size_t)(iBit + iByte * 8), bit);
  }
  bool isOk = true;
  loop(iByte, 2) loop(iBit, 8) {
    bool bit = $(arr, getBit)((size_t)(iBit + iByte * 8));
    isOk &= (bit == ((bytes[iByte] >> (7 - iBit)) & 1));
  }
  loop(iByte, 2) loop(iBit, 8) {
    bool bit = ((bytes[1 - iByte] >> (7 - iBit)) & 1);
    $(arr, setBit)((size_t)(iBit + iByte * 8), bit);
  }
  loop(iByte, 2) loop(iBit, 8) {
    bool bit = $(arr, getBit)((size_t)(iBit + iByte * 8));
    isOk &= (bit == ((bytes[1 - iByte] >> (7 - iBit)) & 1));
  }
  CUTEST_ASSERT(isOk, "set bits failed");
  CapyBitArrayFree(&arr);
}

