#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "BNoise eval") {
  CapyBNoise* noise = CapyBNoiseAlloc(3, 1);
  double in[2];
  double check[3][3] = {
    {0.213749, 0.241154, 0.213749},
    {0.310044, 0.190298, 0.310044},
    {0.213749, 0.241154, 0.213749},
  };
  loop(i, 3) loop(j, 3) {
    in[0] = (double)i / 2.0;
    in[1] = (double)j / 2.0;
    double out[1];
    $(noise, eval)(in, out);
    CUTEST_ASSERT(
      fabs(out[0] - check[i][j]) < 0.0001,
      "unexpected value [%d,%d]=%f != %f",
      i, j, out[0], check[i][j]);
  }
  CapyBNoiseFree(&noise);
}

CUTEST(test002, "BNoise tiling and negative") {
  CapyBNoise* noise = CapyBNoiseAlloc(3, 1);
  double in[2];
  double check[3][3] = {
    {0.213749, 0.241154, 0.213749},
    {0.310044, 0.190298, 0.310044},
    {0.213749, 0.241154, 0.213749},
  };
  loop(i, 3) loop(j, 3) {
    in[0] = (double)i / 2.0 - 1.0;
    in[1] = (double)j / 2.0 - 1.0;
    double out[1];
    $(noise, eval)(in, out);
    CUTEST_ASSERT(
      fabs(out[0] - check[i][j]) < 0.0001,
      "unexpected value [%d,%d]=%f != %f",
      i, j, out[0], check[i][j]);
  }
  CapyBNoiseFree(&noise);
}
