#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "(-3, -1)->(1, 3)") {
  int64_t check[4][2] = {{-3, -1}, {-2, 0}, {-1, 1}, {0, 2}};
  CapyBresenham* iter = CapyBresenhamAlloc();
  iter->startPos[0] = -3;
  iter->startPos[1] = -1;
  iter->endPos[0] = 1;
  iter->endPos[1] = 3;
  forEach(pos, *iter) {
    CUTEST_ASSERT(
      pos[0] == check[iter->idx][0] && pos[1] == check[iter->idx][1],
      "%lu, (%ld,%ld) == (%ld,%ld)",
      iter->idx, pos[0], pos[1], check[iter->idx][0], check[iter->idx][1]);
  }
}

CUTEST(test002, "(1, 3)->(-3, -1)") {
  int64_t check[4][2] = {{1, 3}, {0, 2}, {-1, 1}, {-2, 0}};
  CapyBresenham* iter = CapyBresenhamAlloc();
  iter->startPos[0] = 1;
  iter->startPos[1] = 3;
  iter->endPos[0] = -3;
  iter->endPos[1] = -1;
  forEach(pos, *iter) {
    CUTEST_ASSERT(
      pos[0] == check[iter->idx][0] && pos[1] == check[iter->idx][1],
      "%lu, (%ld,%ld) == (%ld,%ld)",
      iter->idx, pos[0], pos[1], check[iter->idx][0], check[iter->idx][1]);
  }
}

CUTEST(test003, "(-2, -2)->(2, -2)") {
  int64_t check[4][2] = {{-2, -2}, {-1, -2}, {0, -2}, {1, -2}};
  CapyBresenham* iter = CapyBresenhamAlloc();
  iter->startPos[0] = -2;
  iter->startPos[1] = -2;
  iter->endPos[0] = 2;
  iter->endPos[1] = -2;
  forEach(pos, *iter) {
    CUTEST_ASSERT(
      pos[0] == check[iter->idx][0] && pos[1] == check[iter->idx][1],
      "%lu, (%ld,%ld) == (%ld,%ld)",
      iter->idx, pos[0], pos[1], check[iter->idx][0], check[iter->idx][1]);
  }
}
