#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  uint8_t a;
  CapyPad(uint8_t, a);
  void (*destruct)(void);
} Dummy;

static int DummyCmp(
  Dummy const* const elemA,
  Dummy const* const elemB) {
  if(elemA->a < elemB->a) return -1;
  if(elemA->a > elemB->a) return 1;
  else return 0;
}

CapyDecBTree(BTreeDummy, Dummy)
CapyDefBTree(BTreeDummy, Dummy)
#endif
CUTEST(test001, "Create a BTree and free it") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  BTreeDummy* ptr = btree;
  bool isOk =
    (btree->nbElem == 0) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  BTreeDummyFree(&btree);
  isOk &= (ptr != NULL) && (btree == NULL);
  CUTEST_ASSERT(isOk, "isOk=%d", isOk);
}

CUTEST(test002, "Add (1)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy = {.a = 1};
  $(btree, add)(dummy);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test003, "Add (2)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[2] = {{.a = 1}, {.a = 2}};
  loop(i, 2) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 2) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test004, "Add (3)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[3] = {{.a = 1}, {.a = 2}, {.a = 3}};
  loop(i, 3) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 2) &&
    (btree->elems[2].a == 3) &&
    (btree->nbElem == 3) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test005, "Add (4)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[3] = {{.a = 3}, {.a = 1}, {.a = 2}};
  loop(i, 3) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 2) &&
    (btree->elems[2].a == 3) &&
    (btree->nbElem == 3) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test006, "Add (5)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}};
  loop(i, 4) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 4) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test007, "Add (6)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 4}, {.a = 3}};
  loop(i, 4) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 4) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test008, "Add (7)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 3}, {.a = 4}, {.a = 2}};
  loop(i, 4) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 3) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->nbElem == 1) &&
    (btree->childs[0]->nbElem == 2) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->elems[1].a == 2) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test009, "Add (8)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 2}, {.a = 3}, {.a = 4}, {.a = 1}};
  loop(i, 4) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 3) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->nbElem == 1) &&
    (btree->childs[0]->nbElem == 2) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->elems[1].a == 2) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test010, "Add (9)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[5] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 5) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 3) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 4) &&
    (btree->childs[1]->elems[2].a == 5) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test011, "Add (10)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[5] = {{.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 1}};
  loop(i, 5) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 3) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 2) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->elems[1].a == 2) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[1]->elems[1].a == 5) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test012, "Add (11)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test013, "Add (12)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 6}, {.a = 5}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test014, "Add (13)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 6}, {.a = 4}, {.a = 5}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test015, "Add (14)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 6}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test016, "Add (15)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 6}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test017, "Add (16)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 6}, {.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test018, "Add (17)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 6}, {.a = 5}, {.a = 4}, {.a = 3}, {.a = 2}, {.a = 1}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 3) &&
    (btree->elems[1].a == 5) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 2) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->elems[1].a == 2) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test019, "Add (18)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 5}, {.a = 6}, {.a = 3}, {.a = 2}, {.a = 4}};
  loop(i, 6) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 5) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 4) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test020, "Find (1)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 5}, {.a = 6}, {.a = 3}, {.a = 2}, {.a = 4}};
  loop(i, 5) $(btree, add)(dummy[i]);
  Dummy* elem = NULL;
  bool isOk = true;
  Dummy* check[6] = {
    btree->childs[0]->elems,
    btree->elems,
    btree->childs[1]->elems,
    btree->childs[0]->elems + 2,
    btree->childs[0]->elems + 1,
    NULL,
  };
  loop(i, 6) {
    elem = $(btree, find)(dummy[i]);
    isOk &= (elem == check[i]);
  }
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test021, "Remove (1)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[1] = {{.a = 1}};
  loop(i, 1) $(btree, add)(dummy[i]);
  loop(i, 1) $(btree, remove)(dummy[i]);
  bool isOk =
    (btree->nbElem == 0) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test022, "Remove (2)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[3] = {{.a = 1}, {.a = 2}, {.a = 3}};
  loop(i, 3) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[1]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 3) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test023, "Remove (3)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}};
  loop(i, 4) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[3]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test024, "Remove (4)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}};
  loop(i, 4) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[2]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test025, "Remove (5)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}};
  loop(i, 4) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[0]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 3) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 2) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test026, "Remove (6)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}};
  loop(i, 4) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[1]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 3) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test027, "Remove (7)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[5] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 5) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[2]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[1]->elems[1].a == 5) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test028, "Remove (8)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[5] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 5) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[3]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 5) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test029, "Remove (9)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[5] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}};
  loop(i, 5) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[4]);
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[1]->elems[1].a == 4) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test030, "Remove (10)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[0]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test031, "Remove (11)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[1]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 2) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[2]->elems[1].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test032, "Remove (12)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[2]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 5) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 4) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test033, "Remove (13)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[3]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 5) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test034, "Remove (14)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[4]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 6) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test035, "Remove (15)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[5]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test036, "Remove (16)") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[6] = {{.a = 1}, {.a = 2}, {.a = 3}, {.a = 4}, {.a = 5}, {.a = 6}};
  loop(i, 6) $(btree, add)(dummy[i]);
  $(btree, remove)(dummy[5]);
  $(btree, remove)(dummy[4]);
  bool isOk =
    (btree->nbElem == 2) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test037, "Add and remove 9 elements") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  size_t nbElem = 9;
  Dummy dummy = {0};
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)(iElem + 1);
    $(btree, add)(dummy);
  }
  bool isOk =
    (btree->nbElem == 3) &&
    (btree->elems[0].a == 2) &&
    (btree->elems[1].a == 4) &&
    (btree->elems[2].a == 6) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 1) &&
    (btree->childs[1]->elems[0].a == 3) &&
    (btree->childs[2] != NULL) &&
    (btree->childs[2]->parent == btree) &&
    (btree->childs[2]->nbElem == 1) &&
    (btree->childs[2]->elems[0].a == 5) &&
    (btree->childs[3] != NULL) &&
    (btree->childs[3]->parent == btree) &&
    (btree->childs[3]->nbElem == 3) &&
    (btree->childs[3]->elems[0].a == 7) &&
    (btree->childs[3]->elems[1].a == 8) &&
    (btree->childs[3]->elems[2].a == 9);
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)iElem;
    $(btree, remove)(dummy);
  }
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test038, "Add and remove 10 elements") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  size_t nbElem = 10;
  Dummy dummy = {0};
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)(iElem + 1);
    $(btree, add)(dummy);
  }
  bool isOk =
    (btree->nbElem == 1) &&
    (btree->elems[0].a == 4) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 2) &&
    (btree->childs[0]->childs[0] != NULL) &&
    (btree->childs[0]->childs[0]->parent == btree->childs[0]) &&
    (btree->childs[0]->childs[0]->nbElem == 1) &&
    (btree->childs[0]->childs[0]->elems[0].a == 1) &&
    (btree->childs[0]->childs[1] != NULL) &&
    (btree->childs[0]->childs[1]->parent == btree->childs[0]) &&
    (btree->childs[0]->childs[1]->nbElem == 1) &&
    (btree->childs[0]->childs[1]->elems[0].a == 3) &&
    (btree->childs[0]->childs[2] == NULL) &&
    (btree->childs[0]->childs[3] == NULL) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 6) &&
    (btree->childs[1]->elems[1].a == 8) &&
    (btree->childs[1]->childs[0] != NULL) &&
    (btree->childs[1]->childs[0]->parent == btree->childs[1]) &&
    (btree->childs[1]->childs[0]->nbElem == 1) &&
    (btree->childs[1]->childs[0]->elems[0].a == 5) &&
    (btree->childs[1]->childs[1] != NULL) &&
    (btree->childs[1]->childs[1]->parent == btree->childs[1]) &&
    (btree->childs[1]->childs[1]->nbElem == 1) &&
    (btree->childs[1]->childs[1]->elems[0].a == 7) &&
    (btree->childs[1]->childs[2] != NULL) &&
    (btree->childs[1]->childs[2]->parent == btree->childs[1]) &&
    (btree->childs[1]->childs[2]->nbElem == 2) &&
    (btree->childs[1]->childs[2]->elems[0].a == 9) &&
    (btree->childs[1]->childs[2]->elems[1].a == 10) &&
    (btree->childs[1]->childs[3] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)iElem;
    $(btree, remove)(dummy);
  }
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test039, "Add and remove 100 elements") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  size_t nbElem = 100;
  Dummy dummy = {0};
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)iElem + 1;
    $(btree, add)(dummy);
  }
  loop(iElem, nbElem) {
    dummy.a = (uint8_t)iElem + 1;
    $(btree, remove)(dummy);
  }
  bool isOk = (btree->nbElem == 0);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test040, "Add and remove 100 random elements") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  CapyRandom rnd = CapyRandomCreate(1);
  size_t nbElem = 100;
  CapyArrUInt8 arr = CapyArrUInt8Create(nbElem);
  loop(iElem, nbElem) {
    uint8_t val = (uint8_t)iElem;
    $(&arr, set)(iElem, &val);
  }
  $(&arr, shuffle)(&rnd);
  Dummy dummy = {0};
  loop(iElem, nbElem) {
    dummy.a = $(&arr, get)(iElem);
    $(btree, add)(dummy);
  }
  $(&arr, shuffle)(&rnd);
  loop(iElem, nbElem) {
    dummy.a = $(&arr, get)(iElem);
    $(btree, remove)(dummy);
  }
  bool isOk = (btree->nbElem == 0);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
  $(&arr, destruct)();
  $(&rnd, destruct)();
}

CUTEST(test041, "Add twice the same value") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[2] = {{.a = 1}, {.a = 1}};
  loop(i, 2) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->elems[1].a == 1) &&
    (btree->nbElem == 2) &&
    (btree->parent == NULL) &&
    (btree->childs[0] == NULL) &&
    (btree->childs[1] == NULL) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test042, "Add four time the same value") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 1}, {.a = 1}, {.a = 1}};
  loop(i, 4) $(btree, add)(dummy[i]);
  bool isOk =
    (btree->elems[0].a == 1) &&
    (btree->nbElem == 1) &&
    (btree->parent == NULL) &&
    (btree->childs[0] != NULL) &&
    (btree->childs[0]->parent == btree) &&
    (btree->childs[0]->nbElem == 1) &&
    (btree->childs[0]->elems[0].a == 1) &&
    (btree->childs[1] != NULL) &&
    (btree->childs[1]->parent == btree) &&
    (btree->childs[1]->nbElem == 2) &&
    (btree->childs[1]->elems[0].a == 1) &&
    (btree->childs[1]->elems[1].a == 1) &&
    (btree->childs[2] == NULL) &&
    (btree->childs[3] == NULL);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test043, "Add four time the same value and remove them") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  Dummy dummy[4] = {{.a = 1}, {.a = 1}, {.a = 1}, {.a = 1}};
  loop(i, 4) $(btree, add)(dummy[i]);
  loop(i, 4) $(btree, remove)(dummy[i]);
  bool isOk = (btree->nbElem == 0);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
}

CUTEST(test044, "Add and remove 500 random elements with repeating ones") {
  BTreeDummy* btree = BTreeDummyAlloc(3, DummyCmp);
  CapyRandom rnd = CapyRandomCreate(1);
  size_t nbElem = 500;
  CapyArrUInt8 arr = CapyArrUInt8Create(nbElem);
  loop(iElem, nbElem) {
    uint8_t val = (uint8_t)iElem;
    $(&arr, set)(iElem, &val);
  }
  $(&arr, shuffle)(&rnd);
  Dummy dummy = {0};
  loop(iElem, nbElem) {
    dummy.a = $(&arr, get)(iElem);
    $(btree, add)(dummy);
  }
  $(&arr, shuffle)(&rnd);
  loop(iElem, nbElem) {
    dummy.a = $(&arr, get)(iElem);
    $(btree, remove)(dummy);
  }
  bool isOk = (btree->nbElem == 0);
  CUTEST_ASSERT(isOk, "operation failed");
  BTreeDummyFree(&btree);
  $(&arr, destruct)();
  $(&rnd, destruct)();
}

