#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "BWT (1)") {
  CapyBurrowsWheelerTransform* bwt = CapyBurrowsWheelerTransformAlloc();
  char const* str = "^BANANA$";
  CapyBurrowsWheelerTransformData data =
    {.bytes = (uint8_t*)str, .size = strlen(str)};
  CapyBurrowsWheelerTransformData res = $(bwt, transform)(data);
  CapyBurrowsWheelerTransformData dataBack = $(bwt, untransform)(res);
  bool isOk = false;
  if(data.size == res.size && res.bytes != NULL) {
    uint8_t check[] = {'A', 'N', 'N', 'B', '^', 'A', 'A', '$'};
    isOk = true;
    loop(i, res.size) isOk &= (res.bytes[i] == check[i]);
    isOk &= (res.idxFirstByte == 4);
  }
  if(isOk && data.size == dataBack.size && dataBack.bytes != NULL) {
    loop(i, data.size) isOk &= (data.bytes[i] == dataBack.bytes[i]);
  } else isOk = false;
  CUTEST_ASSERT(isOk, "BWT failed");
  CapyBurrowsWheelerTransformFree(&bwt);
  free(res.bytes);
  free(dataBack.bytes);
}

CUTEST(test002, "BWT (2)") {
  CapyBurrowsWheelerTransform* bwt = CapyBurrowsWheelerTransformAlloc();
  char const* str = "It_was_the_best_of_times_it_was_the_worst_of_times$";
  CapyBurrowsWheelerTransformData data =
    {.bytes = (uint8_t*)str, .size = strlen(str)};
  CapyBurrowsWheelerTransformData res = $(bwt, transform)(data);
  CapyBurrowsWheelerTransformData dataBack = $(bwt, untransform)(res);
  bool isOk = false;
  if(data.size == res.size && res.bytes != NULL) {
    uint8_t check[] = {
      's', '$', 'e', 's', 't', 't', 's', 's', 'f', 'f', 't', 't', 'e', 'w',
      'w', '_', 'h', 'h', 'm', 'm', 'b', 'o', 'o', 't', 't', 't', 't', '_',
      'i', 'i', '_', '_', 'w', 'o', 'e', 'e', 'a', 'a', 'r', 'e', 's', 's',
      'I', 'i', '_', '_', '_', '_', '_', '_', '_'
    };
    isOk = true;
    loop(i, res.size) isOk &= (res.bytes[i] == check[i]);
    isOk &= (res.idxFirstByte == 42);
  }
  if(isOk && data.size == dataBack.size && dataBack.bytes != NULL) {
    loop(i, data.size) isOk &= (data.bytes[i] == dataBack.bytes[i]);
  } else isOk = false;
  CUTEST_ASSERT(isOk, "BWT failed");
  CapyBurrowsWheelerTransformFree(&bwt);
  free(res.bytes);
  free(dataBack.bytes);
}
