#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Create/free") {
  CapyCamera* camera = CapyCameraAlloc();
  CUTEST_ASSERT(
    camera->type == capyCameraType_pinhole &&
    equal(camera->focalLength, 0.017) &&
    equal(camera->sensorResolution, 100000.0) &&
    camera->pos.dim == 3 &&
    camera->pos.vals != NULL &&
    equal(camera->pos.vals[0], 0.0) &&
    equal(camera->pos.vals[1], 0.0) &&
    equal(camera->pos.vals[2], 0.0) &&
    camera->pose.nbCol == 3 &&
    camera->pose.nbRow == 3 &&
    camera->pose.vals != NULL &&
    equal(camera->pose.vals[0], 1.0) &&
    equal(camera->pose.vals[1], 0.0) &&
    equal(camera->pose.vals[2], 0.0) &&
    equal(camera->pose.vals[3], 0.0) &&
    equal(camera->pose.vals[4], 1.0) &&
    equal(camera->pose.vals[5], 0.0) &&
    equal(camera->pose.vals[6], 0.0) &&
    equal(camera->pose.vals[7], 0.0) &&
    equal(camera->pose.vals[8], 1.0),
    "Alloc failed");
  CapyCameraFree(&camera);
}

CUTEST(test002, "Project pinhole (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  double in[3] = {0, 0, 1};
  double check[3] = {0, 0, 1};
  double out[3];
  $(camera, project)(in, out);
  bool ok = true;
  loop(i, 3) ok &= equal(out[i], check[i]);
  CUTEST_ASSERT(
    ok, "projection failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test003, "Project pinhole (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  double in[3] = {1, 1, 1};
  double check[3] = {0.017, 0.017, 1};
  double out[3];
  $(camera, project)(in, out);
  bool ok = true;
  loop(i, 3) ok &= equal(out[i], check[i]);
  CUTEST_ASSERT(
    ok, "projection failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test004, "toImgCoord perspective (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  CapyImgPos posOrig = {.x = 400, .y = 300};
  double in[3] = {0, 0, 1};
  CapyImgPos_t check[2] = {400, 300};
  double out[3];
  $(camera, project)(in, out);
  CapyImgPos_t pos[2] = {0};
  $(camera, toImgCoord)(out, posOrig.coords, pos);
  bool ok = true;
  loop(i, 2) ok &= (pos[i] == check[i]);
  CUTEST_ASSERT(
    ok, "toImgCoord failed [%d, %d] != [%d, %d]",
    pos[0], pos[1], check[0], check[1]);
  CapyCameraFree(&camera);
}

CUTEST(test005, "toImgCoord perspective (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  CapyImgPos posOrig = {.x = 400, .y = 300};
  double in[3] = {1, 1, 10};
  CapyImgPos_t check[2] = {570, 130};
  double out[3];
  $(camera, project)(in, out);
  CapyImgPos_t pos[2] = {0};
  $(camera, toImgCoord)(out, posOrig.coords, pos);
  bool ok = true;
  loop(i, 2) ok &= (pos[i] == check[i]);
  CUTEST_ASSERT(
    ok, "toImgCoord failed [%d, %d] != [%d, %d]",
    pos[0], pos[1], check[0], check[1]);
  CapyCameraFree(&camera);
}

CUTEST(test006, "Inverse project pinhole (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  double in[3] = {0, 0, 1};
  double check[3] = {0, 0, 1};
  double out[3];
  $(camera, projectInv)(in, out);
  bool ok = true;
  loop(i, 3) ok &= equal(out[i], check[i]);
  CUTEST_ASSERT(
    ok, "projection failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test007, "Inverse project pinhole (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  double in[3] = {0.017, 0.017, 1};
  double check[3] = {1, 1, 1};
  double out[3];
  $(camera, projectInv)(in, out);
  bool ok = true;
  loop(i, 3) ok &= equal(out[i], check[i]);
  CUTEST_ASSERT(
    ok, "projection failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test008, "fromImgCoord perspective (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  CapyImgPos posOrig = {.x = 400, .y = 300};
  CapyImgPos_t in[2] = {400, 300};
  double check[3] = {0, 0, 1};
  double out[3];
  $(camera, fromImgCoord)(in, posOrig.coords, out);
  bool ok = true;
  loop(i, 3) ok &= (out[i] == check[i]);
  CUTEST_ASSERT(
    ok, "fromImgCoord failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test009, "fromImgCoord perspective (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  CapyImgPos posOrig = {.x = 400, .y = 300};
  CapyImgPos_t in[2] = {570, 130};
  double check[3] = {0.099014, 0.099014, 0.990147};
  double out[3];
  $(camera, fromImgCoord)(in, posOrig.coords, out);
  bool ok = true;
  loop(i, 3) ok &= (fabs(out[i] - check[i]) < 1e-6);
  CUTEST_ASSERT(
    ok, "fromImgCoord failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test010, "toImgCoord orthographic (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  camera->screenType = capyCameraScreenType_orthographic;
  CapyImgPos posOrig = {.x = 400, .y = 300};
  double in[3] = {0, 0, 1};
  CapyImgPos_t check[2] = {400, 300};
  double out[3];
  $(camera, project)(in, out);
  CapyImgPos_t pos[2] = {0};
  $(camera, toImgCoord)(out, posOrig.coords, pos);
  bool ok = true;
  loop(i, 2) ok &= (pos[i] == check[i]);
  CUTEST_ASSERT(
    ok, "toImgCoord failed [%d, %d] != [%d, %d]",
    pos[0], pos[1], check[0], check[1]);
  CapyCameraFree(&camera);
}

CUTEST(test011, "toImgCoord orthographic (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  camera->screenType = capyCameraScreenType_orthographic;
  CapyImgPos posOrig = {.x = 400, .y = 300};
  double in[3] = {1, 1, 10};
  CapyImgPos_t check[2] = {2100, -1400};
  double out[3];
  $(camera, project)(in, out);
  CapyImgPos_t pos[2] = {0};
  $(camera, toImgCoord)(out, posOrig.coords, pos);
  bool ok = true;
  loop(i, 2) ok &= (pos[i] == check[i]);
  CUTEST_ASSERT(
    ok, "toImgCoord failed [%d, %d] != [%d, %d]",
    pos[0], pos[1], check[0], check[1]);
  CapyCameraFree(&camera);
}

CUTEST(test012, "fromImgCoord orthographic (1)") {
  CapyCamera* camera = CapyCameraAlloc();
  camera->screenType = capyCameraScreenType_orthographic;
  CapyImgPos posOrig = {.x = 400, .y = 300};
  CapyImgPos_t in[2] = {400, 300};
  double check[3] = {0, 0, 1};
  double out[3];
  $(camera, fromImgCoord)(in, posOrig.coords, out);
  bool ok = true;
  loop(i, 3) ok &= (out[i] == check[i]);
  CUTEST_ASSERT(
    ok, "fromImgCoord failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test013, "fromImgCoord orthographic (2)") {
  CapyCamera* camera = CapyCameraAlloc();
  camera->screenType = capyCameraScreenType_orthographic;
  CapyImgPos posOrig = {.x = 400, .y = 300};
  CapyImgPos_t in[2] = {2100, -1400};
  double check[3] = {0.57735, 0.57735, 0.57735};
  double out[3];
  $(camera, fromImgCoord)(in, posOrig.coords, out);
  bool ok = true;
  loop(i, 3) ok &= (fabs(out[i] - check[i]) < 1e-6);
  CUTEST_ASSERT(
    ok, "fromImgCoord failed [%lf, %lf, %lf] != [%lf, %lf, %lf]",
    out[0], out[1], out[2], check[0], check[1], check[2]);
  CapyCameraFree(&camera);
}

CUTEST(test014, "Isometric camera") {
  CapyCamera* camera = CapyCameraAlloc();
  $(camera, setToIsometric)();
  double in[4][3] = {{0, 0, 0}, {100, 0, 0}, {0, 100, 0}, {0, 0, 100}};
  CapyImgPos_t check[4][2] = {{0, 0}, {-70, 49}, {0, -71}, {70, 49}};
  bool isOk = true;
  loop(iCheck, 4) {
    double out[3];
    $(camera, project)(in[iCheck], out);
    CapyImgPos_t pos[2] = {0};
    CapyImgPos posOrig = {.x = 0, .y = 0};
    $(camera, toImgCoord)(out, posOrig.coords, pos);
    loop(i, 2) isOk &= (pos[i] == check[iCheck][i]);
  }
  CUTEST_ASSERT(isOk, "setToIsometric failed");
  CapyCameraFree(&camera);
}

CUTEST(test015, "Dimetric camera") {
  CapyCamera* camera = CapyCameraAlloc();
  $(camera, setToDimetric)();
  double in[4][3] = {{0, 0, 0}, {100, 0, 0}, {0, 100, 0}, {0, 0, 100}};
  CapyImgPos_t check[4][2] = {{0, 0}, {-70, 35}, {0, -86}, {70, 35}};
  bool isOk = true;
  loop(iCheck, 4) {
    double out[3];
    $(camera, project)(in[iCheck], out);
    CapyImgPos_t pos[2] = {0};
    CapyImgPos posOrig = {.x = 0, .y = 0};
    $(camera, toImgCoord)(out, posOrig.coords, pos);
    loop(i, 2) isOk &= (pos[i] == check[iCheck][i]);
  }
  CUTEST_ASSERT(isOk, "setToIsometric failed");
  CapyCameraFree(&camera);
}

