#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "CapyGetVersion") {
  char const* version = CapyGetVersion();
  CUTEST_ASSERT(version != NULL, "version is null");
  CUTEST_ASSERT(version[0] != 0, "version is an empty string");
  CUTEST_ASSERT(
    isdigit(version[0]), "version must start with a digit (%s)", version);
}

CUTEST(test002, "CapyGetCommitId") {
  char const* commit = CapyGetCommitId();
  CUTEST_ASSERT(commit != NULL, "commit is null");
  CUTEST_ASSERT(commit[0] != 0, "commit is an empty string");
}

CUTEST(test003, "CapyGetBuildMode") {
  Capy_BuildMode build = CapyGetBuildMode();
  CUTEST_ASSERT(build == 0 || build == 1, "invalid build mode (%d)", build);
}

CUTEST(test007, "type size") {
  size_t sizeFloat = sizeof(float);
  size_t sizeDouble = sizeof(double);
  size_t sizeInt32 = sizeof(int32_t);
  size_t sizeInt64 = sizeof(int64_t);
  CUTEST_ASSERT(
    sizeFloat == sizeInt32,
    "unexpected size of float %ld != %ld", sizeFloat, sizeInt32);
  CUTEST_ASSERT(
    sizeDouble == sizeInt64,
    "unexpected size of double %ld != %ld", sizeDouble, sizeInt64);
}
