#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc/free") {
  CapyCatmullRom* that = CapyCatmullRomAlloc(2);
  CUTEST_ASSERT(
    that->dimIn == 1 && that->dimOut == 2 && fabs(that->alpha - 0.5) < 1e-6,
    "Alloc failed");
  CapyCatmullRomFree(&that);
}

CUTEST(test002, "Set/get") {
  CapyCatmullRom* that = CapyCatmullRomAlloc(2);
  double vals[2] = {1.0, 2.0};
  $(that, setCtrl)(1, vals);
  CapyVec const* u = $(that, getCtrl)(1);
  CUTEST_ASSERT(
    fabs(u->vals[0] - vals[0]) < 1e-6 && fabs(u->vals[1] - vals[1]) < 1e-6 &&
    fabs(that->knots[0] - 0.0) < 1e-6 &&
    fabs(that->knots[1] - 1.495349) < 1e-6 &&
    fabs(that->knots[2] - 2.990698) < 1e-6 &&
    fabs(that->knots[3] - 2.990698) < 1e-6,
    "Set/get failed");
  CapyCatmullRomFree(&that);
}

CUTEST(test003, "Eval") {
  CapyCatmullRom* that = CapyCatmullRomAlloc(2);
  double vals[2] = {1.0, 2.0};
  $(that, setCtrl)(1, vals);
  $(that, setCtrl)(3, vals);
  double evals[10][2];
  double checkEvals[10][2] = {
    {1.000000, 2.000000},
    {0.972000, 1.944000},
    {0.896000, 1.792000},
    {0.784000, 1.568000},
    {0.648000, 1.296000},
    {0.500000, 1.000000},
    {0.352000, 0.704000},
    {0.216000, 0.432000},
    {0.104000, 0.208000},
    {0.028000, 0.056000},
  };
  bool isOk = true;
  loop(i, 10) {
    double t = 0.1 * (double)i;
    $(that, eval)(&t, evals[i]);
    loop(j, 2) isOk &= fabs(evals[i][j] - checkEvals[i][j]) < 1e-6;
  }
  CUTEST_ASSERT(isOk, "Eval failed");
  CapyCatmullRomFree(&that);
}

CUTEST(test004, "Iterator") {
  CapyCatmullRom* that = CapyCatmullRomAlloc(2);
  double vals[2] = {1.0, 2.0};
  $(that, setCtrl)(1, vals);
  $(that, setCtrl)(3, vals);
  CapyCatmullRomIterator* iter = CapyCatmullRomIteratorAlloc(that);
  iter->epsilon = 0.2;
  double checkEvals[17][3] = {
    {0.000000, 1.000000, 2.000000},
    {0.125000, 0.957031, 1.914062},
    {0.187500, 0.907715, 1.815430},
    {0.250000, 0.843750, 1.687500},
    {0.312500, 0.768066, 1.536133},
    {0.375000, 0.683594, 1.367187},
    {0.406250, 0.638977, 1.277954},
    {0.437500, 0.593262, 1.186523},
    {0.468750, 0.546814, 1.093628},
    {0.500000, 0.500000, 1.000000},
    {0.531250, 0.453186, 0.906372},
    {0.562500, 0.406738, 0.813477},
    {0.593750, 0.361023, 0.722046},
    {0.625000, 0.316406, 0.632812},
    {0.687500, 0.231934, 0.463867},
    {0.750000, 0.156250, 0.312500},
    {0.812500, 0.092285, 0.184570},
  };
  bool isOk = true;
  forEach(pos, *iter) {
    isOk &=
      fabs(pos.in[0] - checkEvals[iter->idx][0]) < 1e-6 &&
      fabs(pos.out[0] - checkEvals[iter->idx][1]) < 1e-6 &&
      fabs(pos.out[1] - checkEvals[iter->idx][2]) < 1e-6;
  }
  CUTEST_ASSERT(isOk, "Iteration failed");
  CapyCatmullRomIteratorFree(&iter);
  CapyCatmullRomFree(&that);
}
