#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "CapyChrono functions") {
  CapyChrono* chrono = CapyChronoAlloc();
  loop(i, capyChrono_nbUnit) {
    CUTEST_ASSERT(chrono->elapsedTime[i] == 0, "Initialisation failed");
  }
  CapySleepMs(1000);
  $(chrono, stop)();
  CUTEST_ASSERT(
    chrono->elapsedTime[capyChrono_day] == 0,
    "Measured time not as expected %lu != 0",
    chrono->elapsedTime[capyChrono_day]);
  CUTEST_ASSERT(
    chrono->elapsedTime[capyChrono_hour] == 0,
    "Measured time not as expected %lu != 0",
    chrono->elapsedTime[capyChrono_hour]);
  CUTEST_ASSERT(
    chrono->elapsedTime[capyChrono_minute] == 0,
    "Measured time not as expected %lu != 0",
    chrono->elapsedTime[capyChrono_minute]);
  CUTEST_ASSERT(
    chrono->elapsedTime[capyChrono_second] == 1,
    "Measured time not as expected %lu != 1",
    chrono->elapsedTime[capyChrono_second]);
  double timeMs = $(chrono, getElapsedTime)(capyChrono_millisecond);
  CUTEST_ASSERT(
    timeMs >= 1000.0, "Measured time not as expected %lf < 1000", timeMs);
  double timeS = $(chrono, getElapsedTime)(capyChrono_second);
  CUTEST_ASSERT(
    timeS >= 1.0, "Measured time not as expected %lf < 1", timeS);
  double timeM = $(chrono, getElapsedTime)(capyChrono_minute);
  CUTEST_ASSERT(
    timeM >= 1.0 / 60.0 && timeM < 1.5 / 60.0,
    "Measured time not as expected 1/60 < %lf <= 1.5/60", timeM);
  double timeH = $(chrono, getElapsedTime)(capyChrono_hour);
  CUTEST_ASSERT(
    timeH >= 1.0 / 3600.0 && timeH < 1.5 / 3600.0,
    "Measured time not as expected 1/3600 < %lf <= 1.5/3600", timeH);
  double timeD = $(chrono, getElapsedTime)(capyChrono_day);
  CUTEST_ASSERT(
    timeD >= 1.0 / 86400.0 && timeD < 1.5 / 86400.0,
    "Measured time not as expected 1/3600 < %lf <= 1.5/3600", timeD);
  CapyChronoFree(&chrono);
}

CUTEST(test002, "GetElapsedTimeBestUnit") {
  CapyChrono chrono = CapyChronoCreate();
  CapyChronoUnit bestUnit;
  uint16_t testA[capyChrono_nbUnit] = {1, 0, 0, 0, 0};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testA[i];
  double elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 1.0) < 1e-9 && bestUnit == capyChrono_day,
    "Measured time not as expected %lf=1.0 %d=0", elapsedTime, bestUnit);
  uint16_t testB[capyChrono_nbUnit] = {0, 1, 0, 0, 0};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testB[i];
  elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 1.0) < 1e-9 && bestUnit == capyChrono_hour,
    "Measured time not as expected %lf=1.0 %d=1", elapsedTime, bestUnit);
  uint16_t testC[capyChrono_nbUnit] = {0, 1, 30, 0, 0};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testC[i];
  elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 1.5) < 1e-9 && bestUnit == capyChrono_hour,
    "Measured time not as expected %lf=1.5 %d=1", elapsedTime, bestUnit);
  uint16_t testD[capyChrono_nbUnit] = {0, 1, 0, 1800, 0};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testD[i];
  elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 1.5) < 1e-9 && bestUnit == capyChrono_hour,
    "Measured time not as expected %lf=1.5 %d=1", elapsedTime, bestUnit);
  uint16_t testE[capyChrono_nbUnit] = {0, 0, 0, 0, 1};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testE[i];
  elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 1.0) < 1e-9 && bestUnit == capyChrono_millisecond,
    "Measured time not as expected %lf=1.0 %d=4", elapsedTime, bestUnit);
  uint16_t testF[capyChrono_nbUnit] = {0, 0, 0, 0, 0};
  loop(i, capyChrono_nbUnit) chrono.elapsedTime[i] = testF[i];
  elapsedTime = $(&chrono, getElapsedTimeBestUnit)(&bestUnit);
  CUTEST_ASSERT(
    fabs(elapsedTime - 0.0) < 1e-9 && bestUnit == capyChrono_millisecond,
    "Measured time not as expected %lf=0.0 %d=4", elapsedTime, bestUnit);
  $(&chrono, destruct)();
}
