#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Creation/destruction") {
  CapyCollisionDetection* collisiondetection = CapyCollisionDetectionAlloc();
  CUTEST_ASSERT(true, " ");
  CapyCollisionDetectionFree(&collisiondetection);
}

CUTEST(test002a, "Collision detection point/circle (1)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 0, .y = 0};
  CapyCircle circle = {.radius = 1, .center = (CapyPoint2D){.x = 0, .y = 0}};
  bool collision = $(detector, isPointCollidingCircle)(&point, &circle);
  CUTEST_ASSERT(collision, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test002b, "Collision detection point/circle (2)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 2, .y = 0};
  CapyCircle circle = {.radius = 1, .center = (CapyPoint2D){.x = 0, .y = 0}};
  bool collision = $(detector, isPointCollidingCircle)(&point, &circle);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test002c, "Collision detection point/circle (3)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 0, .y = 0};
  CapyCircle circle = {.radius = 1, .center = (CapyPoint2D){.x = 0, .y = 2}};
  bool collision = $(detector, isPointCollidingCircle)(&point, &circle);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test003a, "Collision detection point/rectangle (1)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 0, .y = 0};
  CapyRectangle rect = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isPointCollidingRectangle)(&point, &rect);
  CUTEST_ASSERT(collision, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test003b, "Collision detection point/rectangle (2)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 2, .y = 0};
  CapyRectangle rect = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isPointCollidingRectangle)(&point, &rect);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test003c, "Collision detection point/rectangle (3)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 0, .y = 2};
  CapyRectangle rect = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isPointCollidingRectangle)(&point, &rect);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test003d, "Collision detection point/rectangle (4)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyPoint2D point = {.x = 0, .y = 0};
  CapyRectangle rect = {
    .corners = {
      (CapyPoint2D){.x = -2, .y = -2}, (CapyPoint2D){.x = -1, .y = -1}
    }
  };
  bool collision = $(detector, isPointCollidingRectangle)(&point, &rect);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test004a, "Collision detection circle/circle (1)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyCircle circleA =
    {.radius = 1, .center = (CapyPoint2D){.x = .5, .y = 0}};
  CapyCircle circleB =
    {.radius = 1, .center = (CapyPoint2D){.x = -.5, .y = 0}};
  bool collision = $(detector, isCircleCollidingCircle)(&circleA, &circleB);
  CUTEST_ASSERT(collision, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test004b, "Collision detection circle/circle (2)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyCircle circleA =
    {.radius = 1, .center = (CapyPoint2D){.x = 1.5, .y = 0}};
  CapyCircle circleB =
    {.radius = 1, .center = (CapyPoint2D){.x = -1.5, .y = 0}};
  bool collision = $(detector, isCircleCollidingCircle)(&circleA, &circleB);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test004c, "Collision detection circle/circle (3)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyCircle circleA =
    {.radius = .1, .center = (CapyPoint2D){.x = .5, .y = 0}};
  CapyCircle circleB =
    {.radius = .1, .center = (CapyPoint2D){.x = -.5, .y = 0}};
  bool collision = $(detector, isCircleCollidingCircle)(&circleA, &circleB);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test005a, "Collision detection rectangle/rectangle (1)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyRectangle rectA = {
    .corners = {
      (CapyPoint2D){.x = -2, .y = -2}, (CapyPoint2D){.x = 0, .y = 0}
    }
  };
  CapyRectangle rectB = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isRectangleCollidingRectangle)(&rectA, &rectB);
  CUTEST_ASSERT(collision, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test005b, "Collision detection rectangle/rectangle (2)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyRectangle rectA = {
    .corners = {
      (CapyPoint2D){.x = -4, .y = -4}, (CapyPoint2D){.x = -2, .y = -2}
    }
  };
  CapyRectangle rectB = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isRectangleCollidingRectangle)(&rectA, &rectB);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test005c, "Collision detection rectangle/rectangle (3)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyRectangle rectA = {
    .corners = {
      (CapyPoint2D){.x = 2, .y = -4}, (CapyPoint2D){.x = 3, .y = -2}
    }
  };
  CapyRectangle rectB = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isRectangleCollidingRectangle)(&rectA, &rectB);
  CUTEST_ASSERT(collision == false, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

CUTEST(test005d, "Collision detection rectangle/rectangle (4)") {
  CapyCollisionDetection* detector = CapyCollisionDetectionAlloc();
  CapyRectangle rectA = {
    .corners = {
      (CapyPoint2D){.x = 0, .y = -4}, (CapyPoint2D){.x = 3, .y = 2}
    }
  };
  CapyRectangle rectB = {
    .corners = {
      (CapyPoint2D){.x = -1, .y = -1}, (CapyPoint2D){.x = 1, .y = 1}
    }
  };
  bool collision = $(detector, isRectangleCollidingRectangle)(&rectA, &rectB);
  CUTEST_ASSERT(collision, "collision detection failed");
  CapyCollisionDetectionFree(&detector);
}

