#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Color correction") {
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_sRGB);
  CUTEST_ASSERT(
    chart->nbCol == 5,
    "ColorChart initialiation failed, nbCol=%lu != 5", chart->nbCol);
  CUTEST_ASSERT(
    chart->nbRow == 7,
    "ColorChart initialiation failed, nbRow=%lu != 7", chart->nbRow);
  {
    double rgba[4] = {0.996533, 0.872070, 0.592504, 1.};
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(chart->colors[0].RGBA[i], rgba[i]),
        "ColorChart initialisation failed [%d]=%.20lf != %.20lf",
        i, chart->colors[0].RGBA[i], rgba[i]);
    }
  }
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorChart/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyColorChart imgChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral coords = {
    .corners = {
      {.x = 605, .y = 91}, {.x = 732, .y = 66},
      {.x = 745, .y = 247}, {.x = 624, .y = 270}
    }
  };
  imgChart.kernelSize = 5;
  $(&imgChart, extract)(img, &coords);
  CapyColorData color = $(&imgChart, get)(0, 0);
  {
    double rgba[4] = {
      0.66666666666666640761, 0.57599999999999984546,
      0.37945098039215707786, 1.
    };
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(color.RGBA[i], rgba[i]),
        "ColorChart extraction failed [%d]=%.20lf != %.20lf",
        i, color.RGBA[i], rgba[i]);
    }
  }
  color = $(&imgChart, get)(1, 2);
  {
    double rgba[4] = {
      0.15905882352941175251, 0.42807843137254913968,
      0.48799999999999998934, 1.
    };
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(color.RGBA[i], rgba[i]),
        "ColorChart get failed [%d]=%.20lf != %.20lf",
        i, color.RGBA[i], rgba[i]);
    }
  }
  $(chart, matchBrightness)(&imgChart);
  color = $(chart, get)(0, 0);
  {
    double rgba[4] = {
      0.76011485105959175623, 0.71176752713481905577,
      0.60317085213620114104, 1.
    };
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(color.RGBA[i], rgba[i]),
        "ColorChart matchBrightness failed [%d]=%.20lf != %.20lf",
        i, color.RGBA[i], rgba[i]);
    }
  }
  $(chart, saveToPath)("./UnitTests/TestColorChart/colorChart.dat");
  CapyColorChartFree(&chart);
  chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_sRGB);
  $(chart, loadFromPath)("./UnitTests/TestColorChart/colorChart.dat");
  CUTEST_ASSERT(
    chart->nbCol == 5,
    "ColorChart load/save failed nbCol=%lu != 5", chart->nbCol);
  CUTEST_ASSERT(
    chart->nbRow == 7,
    "ColorChart load/save failed nbRow=%lu != 7", chart->nbRow);
  color = $(chart, get)(0, 0);
  {
    double rgba[4] = {
      0.76011485105959175623, 0.71176752713481905577,
      0.60317085213620114104, 1.
    };
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(color.RGBA[i], rgba[i]),
        "ColorChart load/save failed [%d]=%.20lf != %.20lf",
        i, color.RGBA[i], rgba[i]);
    }
  }
  double similarity = $(chart, getSimilarity)(chart);
  CUTEST_ASSERT(
    fabs(similarity - 1.0) < 0.0001,
    "getSimilarity failed %.20lf != 1", similarity);
  similarity = $(chart, getSimilarity)(&imgChart);
  CUTEST_ASSERT(
    fabs(similarity - 0.75436646980705113208) < 0.0001,
    "getSimilarity failed %.20lf != 0.75436646980705113208", similarity);
  $(&imgChart, destruct)();
  CapyImgFree(&img);
  CapyColorChartFree(&chart);
  CUTEST_ASSERT(chart == NULL, "chart pointer not reset");
}

CUTEST(test002, "Similarity") {
  CapyColorChart chartRGB =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyColorChart chartLAB =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_LAB);
  $(&chartRGB, convertToColorSpace)(capyColorSpace_LAB);
  double similarity = $(&chartLAB, getSimilarity)(&chartRGB);
  CUTEST_ASSERT(
    fabs(similarity - 0.999936) < 0.0001,
    "getSimilarity failed %.20lf != 0.999936", similarity);
  $(&chartRGB, destruct)();
  $(&chartLAB, destruct)();
  chartRGB =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  chartLAB =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_LAB);
  $(&chartRGB, convertToColorSpace)(capyColorSpace_LAB);
  similarity = $(&chartLAB, getSimilarity)(&chartRGB);
  CUTEST_ASSERT(
    fabs(similarity - 0.999936) < 0.0001,
    "getSimilarity failed %.20lf != 0.999936", similarity);
  $(&chartRGB, destruct)();
  $(&chartLAB, destruct)();
}

CUTEST(test003, "Locate") {
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_LAB);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("./UnitTests/TestColorChart/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyQuadrilateral quad =
    $(chart, locate)(img, &capyColorChartDetectDefaultOpt);
  CUTEST_ASSERT(
    fabs(quad.corners[0].x - 603.) < 1.0,
    "locate failed quad.corners[0].x=%.20lf != 603", quad.corners[0].x);
  CUTEST_ASSERT(
    fabs(quad.corners[0].y - 90.) < 1.0,
    "locate failed quad.corners[0].y=%.20lf != 90", quad.corners[0].y);
  CUTEST_ASSERT(
    fabs(quad.corners[1].x - 733.) < 1.0,
    "locate failed quad.corners[1].x=%.20lf != 733", quad.corners[1].x);
  CUTEST_ASSERT(
    fabs(quad.corners[1].y - 63.) < 1.0,
    "locate failed quad.corners[1].y=%.20lf != 63", quad.corners[1].y);
  CUTEST_ASSERT(
    fabs(quad.corners[2].x - 754.) < 1.0,
    "locate failed quad.corners[2].x=%.20lf != 754", quad.corners[2].x);
  CUTEST_ASSERT(
    fabs(quad.corners[2].y - 249.) < 1.0,
    "locate failed quad.corners[2].y=%.20lf != 249", quad.corners[2].y);
  CUTEST_ASSERT(
    fabs(quad.corners[3].x - 622.) < 1.0,
    "locate failed quad.corners[3].x=%.20lf != 622", quad.corners[3].x);
  CUTEST_ASSERT(
    fabs(quad.corners[3].y - 270.) < 1.0,
    "locate failed quad.corners[3].y=%.20lf != 270", quad.corners[3].y);
  CapyImgFree(&img);
  CapyImgPos pos = $(chart, getPatchPos)(&quad, 3, 3);
  CUTEST_ASSERT(pos.x == 703, "getPatchPos failed x=%d != 703", pos.x);
  CUTEST_ASSERT(pos.y == 162, "getPatchPos failed y=%d != 162", pos.y);
  CapyColorChartFree(&chart);
}

CUTEST(test004, "Padding") {
  CUTEST_ASSERT(
    offsetof(CapyColorChartDim, nbRow) == offsetof(CapyColorChartDim, dims[0]),
    "offset of nbRow and dims[0] doesn't match %lu!=%lu",
    offsetof(CapyColorChartDim, nbRow), offsetof(CapyColorChartDim, dims[0]));
  CUTEST_ASSERT(
    offsetof(CapyColorChartDim, nbCol) == offsetof(CapyColorChartDim, dims[1]),
    "offset of nbCol and dims[1] doesn't match %lu!=%lu",
    offsetof(CapyColorChartDim, nbCol), offsetof(CapyColorChartDim, dims[1]));
}
