#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Color correction RGB") {
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorCorrectionBezier/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  CapyColorChart imgChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral quad = {
    .corners = {
      {.x = 605, .y = 91}, {.x = 732, .y = 66},
      {.x = 745, .y = 247}, {.x = 624, .y = 270}
    }
  };
  imgChart.kernelSize = 5;
  $(&imgChart, extract)(img, &quad);
  $(chart, matchBrightness)(&imgChart);
  CapyColorCorrBezier corrBezier = CapyColorCorrBezierCreate();
  corrBezier.colorSpace = capyColorSpace_sRGB;
  $(&corrBezier, match)(&imgChart, chart);
  CUTEST_ASSERT(corrBezier.bezier != NULL, "match failed");
  CUTEST_ASSERT(
    fabs(corrBezier.initialFitness + 6.386472) < 0.001,
    "Unexpected initial fitness %lf", corrBezier.initialFitness);
  CUTEST_ASSERT(
    fabs(corrBezier.finalFitness + 4.959310) < 0.001,
    "Unexpected final fitness %lf", corrBezier.finalFitness);
  $(&corrBezier, saveToPath)(
    "UnitTests/TestColorCorrectionBezier/colorCorrBezier.dat");
  CapyColorCorrBezier* corrBezierLoad = CapyColorCorrBezierAlloc();
  $(corrBezierLoad, loadFromPath)(
    "UnitTests/TestColorCorrectionBezier/colorCorrBezier.dat");
  CapyColorCorrBezierFree(&corrBezierLoad);
  $(&corrBezier, apply)(img);
  $(img, cleanupPixelVals)();
  $(&stream, open)("UnitTests/TestColorCorrectionBezier/test005_.png", "rb");
  CapyImg* corrImg = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  forEach(pixel, corrImg->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        img->pixels[pixel.idx].RGBA[i] < 0.0 ||
        img->pixels[pixel.idx].RGBA[i] > 1.0 ||
        fabs(
          corrImg->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 2.0/255.0,
        "Unexpected result image [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i, img->pixels[pixel.idx].RGBA[i],
        corrImg->pixels[pixel.idx].RGBA[i]);
    }
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&img);
  $(&corrBezier, destruct)();
  $(&imgChart, destruct)();
  CapyImgFree(&img);
  CapyColorChartFree(&chart);
}

CUTEST(test002, "Color correction LAB") {
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_LAB);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorCorrectionBezier/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  CapyColorChart imgChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_LAB);
  CapyQuadrilateral quad = {
    .corners = {
      {.x = 605, .y = 91}, {.x = 732, .y = 66},
      {.x = 745, .y = 247}, {.x = 624, .y = 270}
    }
  };
  imgChart.kernelSize = 5;
  $(&imgChart, extract)(img, &quad);
  $(chart, matchBrightness)(&imgChart);
  CapyColorCorrBezier corrBezier = CapyColorCorrBezierCreate();
  corrBezier.colorSpace = capyColorSpace_LAB;
  $(&corrBezier, match)(&imgChart, chart);
  CUTEST_ASSERT(corrBezier.bezier != NULL, "match failed");
  CUTEST_ASSERT(
    fabs(corrBezier.initialFitness + 323.887895) < 0.001,
    "Unexpected initial fitness %lf", corrBezier.initialFitness);
  CUTEST_ASSERT(
    fabs(corrBezier.finalFitness + 324.348566) < 0.001,
    "Unexpected final fitness %lf", corrBezier.finalFitness);
  $(&corrBezier, saveToPath)(
    "UnitTests/TestColorCorrectionBezier/colorCorrBezier.dat");
  CapyColorCorrBezier* corrBezierLoad = CapyColorCorrBezierAlloc();
  $(corrBezierLoad, loadFromPath)(
    "UnitTests/TestColorCorrectionBezier/colorCorrBezier.dat");
  CapyColorCorrBezierFree(&corrBezierLoad);
  $(&corrBezier, apply)(img);
  $(img, cleanupPixelVals)();
  $(&stream, open)(
    "UnitTests/TestColorCorrectionBezier/test005_bezier_lab.png", "rb"
  );
  CapyImg* corrImg = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  forEach(pixel, corrImg->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        img->pixels[pixel.idx].RGBA[i] < 0.0 ||
        img->pixels[pixel.idx].RGBA[i] > 1.0 ||
        fabs(
          corrImg->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 2.0/255.0,
        "Unexpected result image [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i, img->pixels[pixel.idx].RGBA[i],
        corrImg->pixels[pixel.idx].RGBA[i]);
    }
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&img);
  $(&corrBezier, destruct)();
  $(&imgChart, destruct)();
  CapyImgFree(&img);
  CapyColorChartFree(&chart);
}
