#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Color correction RGB") {
  srand(0);
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorCorrectionMatrix/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(img, setGamma)(1.0);
  CapyColorChart imgChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral quad = {
    .corners = {
      {.x = 605, .y = 91}, {.x = 732, .y = 66},
      {.x = 745, .y = 247}, {.x = 624, .y = 270}
    }
  };
  imgChart.kernelSize = 5;
  $(&imgChart, extract)(img, &quad);
  CapyColorCorrMat* corrMat = CapyColorCorrMatAlloc();
  {
    double check[9] = {1., 0., 0., 0., 1., 0., 0., 0., 1.};
    loop(i, 9) {
      CUTEST_ASSERT(
        equal(corrMat->mat[i], check[i]),
        "extract failed [%d]=%lf != %lf", i, corrMat->mat[i], check[i]);
    }
  }
  $(corrMat, match)(&imgChart, chart);
  CUTEST_ASSERT(
    fabs(corrMat->initialFitness + 5367.798253) < 0.01,
    "unexpected initial fitness %lf", corrMat->initialFitness);
  CUTEST_ASSERT(
    fabs(corrMat->finalFitness + 1.244572) < 0.001,
    "unexpected final fitness %lf", corrMat->finalFitness);
  {
    double check[9] = {
      1.322725, -0.043843, -0.418359, -0.474435, 1.941053, -0.637120,
      -0.380206, 0.107551, 1.077966
    };
    loop(i, 9) {
      CUTEST_ASSERT(
        fabs(corrMat->mat[i] - check[i]) < 0.01,
        "match failed [%d]=%lf != %lf", i, corrMat->mat[i], check[i]);
    }
  }
  $(corrMat, saveToPath)(
    "UnitTests/TestColorCorrectionMatrix/colorCorrMat.dat");
  CapyColorCorrMat* corrMatLoad = CapyColorCorrMatAlloc();
  $(corrMatLoad, loadFromPath)(
    "UnitTests/TestColorCorrectionMatrix/colorCorrMat.dat");
  {
    double check[9] = {
      1.322725, -0.043843, -0.418359, -0.474435, 1.941053, -0.637120,
      -0.380206, 0.107551, 1.077966
    };
    loop(i, 9) {
      CUTEST_ASSERT(
        fabs(corrMatLoad->mat[i] - check[i]) < 0.01,
        "load/save failed [%d]=%lf != %lf", i, corrMatLoad->mat[i], check[i]);
    }
  }
  CapyColorCorrMatFree(&corrMatLoad);
  $(corrMat, apply)(img);
  $(img, setGamma)(2.2);
  CapyImg* corrImg = CapyImgLoadFromPath(
    "UnitTests/TestColorCorrectionMatrix/test005_.png");
  forEach(pixel, corrImg->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        img->pixels[pixel.idx].RGBA[i] < 0.0 ||
        img->pixels[pixel.idx].RGBA[i] > 1.0 ||
        fabs(
          corrImg->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 2.0/255.0,
        "Unexpected result image [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i, img->pixels[pixel.idx].RGBA[i],
        corrImg->pixels[pixel.idx].RGBA[i]);
    }
  }
  CapyImgFree(&corrImg);
  CapyImgFree(&img);
  $(&stream, open)("UnitTests/TestColorCorrectionMatrix/test005.png", "rb");
  img = $(&png, loadImg)(&stream);
  $(&imgChart, extract)(img, &quad);
  $(&stream, open)("UnitTests/TestColorCorrectionMatrix/test004.png", "rb");
  CapyImg* img2 = $(&png, loadImg)(&stream);
  $(img2, setGamma)(1.0);
  CapyColorChart imgChart2 =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral quad2 = {
    .corners = {
      {.x = 600, .y = 93}, {.x = 727, .y = 63},
      {.x = 758, .y = 244}, {.x = 628, .y = 272}
    }
  };
  $(&imgChart2, extract)(img2, &quad2);
  $(corrMat, match)(&imgChart2, &imgChart);
  CUTEST_ASSERT(
    fabs(corrMat->finalFitness + 0.713933) < 0.0001,
    "unexpected final fitness %lf", corrMat->finalFitness);
  $(corrMat, apply)(img2);
  $(img2, setGamma)(2.2);
  $(&imgChart2, destruct)();
  CapyImgFree(&img2);
  $(&stream, open)("UnitTests/TestColorCorrectionMatrix/test006.png", "rb");
  CapyImg* img3 = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  $(img3, setGamma)(1.0);
  CapyColorChart imgChart3 =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral quad3 = {
    .corners = {
      {.x = 606, .y = 90}, {.x = 732, .y = 66},
      {.x = 755, .y = 247}, {.x = 626, .y = 268}
    }
  };
  $(&imgChart3, extract)(img3, &quad3);
  $(corrMat, match)(&imgChart3, &imgChart);
  CUTEST_ASSERT(
    fabs(corrMat->finalFitness + 0.627264) < 0.0001,
    "unexpected final fitness %lf", corrMat->finalFitness);
  $(corrMat, apply)(img3);
  $(&imgChart3, destruct)();
  CapyImgFree(&img3);
  CapyColorCorrMatFree(&corrMat);
  CUTEST_ASSERT(corrMat == NULL, "corrMat not reset");
  $(&imgChart, destruct)();
  CapyImgFree(&img);
  CapyColorChartFree(&chart);
}

CUTEST(test002, "Color correction LAB") {
  CapyColorChart* chart =
    CapyColorChartAlloc(capyColorChart_QP203, capyColorSpace_LAB);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("./UnitTests/TestColorCorrectionMatrix/test005.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  CapyColorChart imgChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyQuadrilateral quad = {
    .corners = {
      {.x = 605, .y = 91}, {.x = 732, .y = 66},
      {.x = 745, .y = 247}, {.x = 624, .y = 270}
    }
  };
  imgChart.kernelSize = 5;
  $(&imgChart, extract)(img, &quad);
  $(chart, matchBrightness)(&imgChart);
  CapyColorCorrMat* corrMat = CapyColorCorrMatAlloc();
  corrMat->colorSpace = capyColorSpace_LAB;
  $(corrMat, match)(&imgChart, chart);
  $(corrMat, apply)(img);
  $(img, cleanupPixelVals)();
  CapyImg* corrImg = CapyImgLoadFromPath(
    "./UnitTests/TestColorCorrectionMatrix/test005CorrLAB.png");
  bool isSameImg = $(img, isSame)(corrImg);
  CUTEST_ASSERT(
    isSameImg,
    "image differs from "
    "./UnitTests/TestColorCorrectionMatrix/test005CorrLAB.png");
  CapyImgFree(&corrImg);
  CapyColorCorrMatFree(&corrMat);
  $(&imgChart, destruct)();
  CapyImgFree(&img);
  CapyColorChartFree(&chart);
}

CUTEST(test003, "Color correction performance") {
  CapyColorChart refChart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyColorChart chart =
    CapyColorChartCreate(capyColorChart_QP203, capyColorSpace_sRGB);
  CapyRandom rnd = CapyRandomCreate(0);
  CapyRangeDouble range = {.min = -0.3, .max = 0.3};
  uint8_t nbTest = 254;
  double sum = 0.0;
  loop(iTest, nbTest) {
    double mat[9] = {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    loop(i, 9) mat[i] += $(&rnd, getDoubleRange)(&range);
    loop(iRow, chart.nbRow) loop(iCol, chart.nbCol) {
      uint64_t idx = iRow * chart.nbCol + iCol;
      loop(i, 3) chart.colors[idx].RGB[i] = 0.0;
      loop(i, 3) loop(k, 3) {
        chart.colors[idx].RGB[i] +=
          mat[i * 3 + k] * refChart.colors[idx].RGB[k];
      }
      loop(i, 3) {
        if(chart.colors[idx].RGB[i] < 0.0) chart.colors[idx].RGB[i] = 0.0;
        if(chart.colors[idx].RGB[i] > 1.0) chart.colors[idx].RGB[i] = 1.0;
      }
    }
    CapyColorCorrMat corrMat = CapyColorCorrMatCreate();
    $(&corrMat, match)(&chart, &refChart);
    double perf = corrMat.finalFitness / corrMat.initialFitness;
    sum += perf;
    $(&corrMat, destruct)();
  }
  sum /= (double)nbTest;
  CUTEST_ASSERT(
    fabs(sum - 0.000008) < 0.0001,
    "correction in color space RGB, linear perturbation, "
    "unexpected avg perf: %lf", sum);
  sum = 0.0;
  loop(iTest, nbTest) {
    loop(iRow, chart.nbRow) loop(iCol, chart.nbCol) {
      uint64_t idx = iRow * chart.nbCol + iCol;
      loop(i, 3) chart.colors[idx].RGB[i] = 0.0;
      loop(i, 3) {
        chart.colors[idx].RGB[i] += 3.0 * $(&rnd, getDoubleRange)(&range);
        if(chart.colors[idx].RGB[i] < 0.0) chart.colors[idx].RGB[i] = 0.0;
        if(chart.colors[idx].RGB[i] > 1.0) chart.colors[idx].RGB[i] = 1.0;
      }
    }
    CapyColorCorrMat corrMat = CapyColorCorrMatCreate();
    $(&corrMat, match)(&chart, &refChart);
    double perf = corrMat.finalFitness / corrMat.initialFitness;
    sum += perf;
    $(&corrMat, destruct)();
  }
  sum /= (double)nbTest;
  CUTEST_ASSERT(
    fabs(sum - 0.000723) < 0.0001,
    "correction in color space RGB, non linear perturbation, "
    "unexpected avg perf: %lf", sum);
  $(&refChart, destruct)();
  $(&chart, destruct)();
}

