#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "extract") {
  CapyColorHisto* histo = CapyColorHistoAlloc();
  loop(i, capyColorHistoType_last) loop(j, CAPY_COLORHISTO_NBBUCKETS) {
    CUTEST_ASSERT(histo->vals[i][j] == 0, "ColorHisto not initialised");
  }
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorHisto/test001.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  $(histo, extract)(img);
  #define nbType capyColorHistoType_last
  uint64_t checkCumulVals[CAPY_COLORHISTO_NBBUCKETS][nbType] = {
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 1, 0},
    {0, 0, 2, 0},
    {0, 0, 4, 0},
    {0, 0, 7, 0},
    {0, 1, 16, 0},
    {0, 1, 22, 0},
    {0, 2, 33, 0},
    {0, 2, 51, 0},
    {1, 5, 77, 1},
    {2, 9, 103, 1},
    {3, 22, 143, 1},
    {6, 44, 193, 2},
    {10, 75, 258, 4},
    {24, 126, 348, 12},
    {56, 185, 473, 26},
    {106, 292, 643, 58},
    {168, 450, 876, 84},
    {263, 652, 1231, 155},
    {364, 886, 1666, 250},
    {479, 1142, 2244, 372},
    {633, 1478, 3045, 524},
    {757, 1853, 4058, 764},
    {895, 2285, 5280, 1015},
    {1023, 2756, 6814, 1266},
    {1164, 3252, 8645, 1574},
    {1327, 3847, 10936, 1889},
    {1498, 4585, 13453, 2272},
    {1715, 5444, 16467, 2669},
    {1946, 6473, 19665, 3144},
    {2177, 7718, 23350, 3707},
    {2437, 9054, 27356, 4388},
    {2719, 10697, 31679, 5130},
    {3080, 12607, 36259, 6102},
    {3485, 14743, 40952, 7283},
    {3909, 17015, 45891, 8669},
    {4401, 19618, 50827, 10262},
    {4949, 22563, 55818, 12161},
    {5538, 25851, 60760, 14223},
    {6198, 29420, 65522, 16480},
    {6958, 33323, 70304, 19043},
    {7747, 37544, 74812, 21880},
    {8743, 42031, 79175, 25026},
    {9794, 46691, 83408, 28464},
    {10995, 51459, 87389, 32268},
    {12420, 56466, 91360, 36380},
    {13996, 61523, 95128, 40870},
    {15828, 66579, 98749, 45549},
    {17830, 71686, 102402, 50358},
    {19934, 76752, 105946, 55319},
    {22266, 81915, 109399, 60408},
    {24814, 87169, 112760, 65520},
    {27703, 92383, 116167, 70470},
    {30773, 97451, 119586, 75692},
    {34113, 102508, 122808, 80923},
    {37703, 107568, 125904, 86093},
    {41587, 112464, 129042, 91266},
    {45840, 117301, 132085, 96508},
    {50208, 122141, 135228, 101527},
    {54824, 126702, 138256, 106477},
    {59545, 131250, 141367, 111482},
    {64406, 135627, 144393, 116412},
    {69422, 140073, 147498, 121179},
    {74379, 144279, 150624, 125896},
    {79389, 148186, 153738, 130612},
    {84335, 152134, 156950, 135300},
    {89244, 155971, 160054, 139813},
    {94127, 159686, 163366, 143989},
    {99085, 163150, 166537, 148020},
    {103862, 166426, 169762, 152011},
    {108478, 169843, 173084, 155753},
    {112931, 173036, 176229, 159326},
    {117446, 176218, 179538, 162770},
    {121763, 179406, 182661, 166002},
    {126003, 182594, 185834, 169189},
    {130231, 185817, 188899, 172350},
    {134397, 189058, 191829, 175443},
    {138544, 192301, 194663, 178601},
    {142746, 195419, 197267, 181637},
    {146868, 198522, 199968, 184728},
    {151135, 201764, 202606, 187871},
    {155193, 204796, 205077, 191044},
    {159382, 207840, 207642, 193999},
    {163587, 210974, 210110, 196905},
    {167930, 214048, 212581, 199747},
    {172070, 217199, 215159, 202652},
    {176212, 220316, 217616, 205479},
    {180197, 223389, 220110, 208417},
    {184202, 226588, 222568, 211319},
    {188156, 229905, 225002, 214182},
    {192120, 233074, 227357, 217010},
    {195890, 236225, 229758, 219883},
    {199652, 239277, 232157, 222915},
    {203350, 242165, 234622, 225927},
    {207138, 245039, 237053, 228986},
    {210880, 247909, 239530, 232031},
    {214632, 250852, 242151, 235099},
    {218510, 253775, 244729, 238004},
    {222115, 256693, 247208, 241012},
    {225653, 259535, 249685, 243984},
    {229050, 262367, 252304, 247033},
    {232356, 265078, 254714, 249959},
    {235563, 267560, 257028, 252964},
    {238694, 269961, 259490, 255910},
    {241712, 272197, 261689, 258750},
    {244650, 274312, 263773, 261530},
    {247558, 276264, 265832, 264184},
    {250392, 278160, 267765, 266771},
    {253197, 279960, 269762, 269275},
    {255863, 281710, 271683, 271512},
    {258436, 283368, 273454, 273703},
    {260885, 284889, 275197, 275747},
    {263193, 286285, 276932, 277745},
    {265438, 287586, 278436, 279549},
    {267675, 288773, 279904, 281318},
    {269731, 289870, 281241, 282992},
    {271648, 290868, 282506, 284506},
    {273474, 291961, 283724, 285936},
    {275340, 292960, 284853, 287340},
    {277049, 293913, 285969, 288643},
    {278644, 294799, 287032, 289798},
    {280164, 295698, 288004, 290941},
    {281714, 296531, 288985, 291971},
    {283180, 297318, 289927, 292949},
    {284533, 298121, 290851, 293870},
    {285919, 298905, 291727, 294772},
    {287220, 299664, 292640, 295647},
    {288488, 300367, 293482, 296506},
    {289727, 301039, 294325, 297309},
    {290933, 301664, 295118, 298089},
    {292080, 302341, 295923, 298857},
    {293082, 302982, 296705, 299577},
    {294037, 303575, 297419, 300288},
    {295020, 304156, 298096, 300965},
    {295963, 304680, 298765, 301618},
    {296834, 305213, 299454, 302203},
    {297686, 305730, 300120, 302782},
    {298487, 306222, 300782, 303401},
    {299273, 306723, 301420, 303963},
    {300054, 307179, 301995, 304495},
    {300829, 307626, 302574, 305045},
    {301561, 308081, 303178, 305548},
    {302296, 308506, 303724, 306051},
    {302988, 308954, 304329, 306557},
    {303675, 309353, 304869, 307050},
    {304322, 309743, 305450, 307551},
    {304982, 310102, 305986, 308029},
    {305610, 310491, 306494, 308525},
    {306230, 310855, 307019, 309000},
    {306847, 311206, 307527, 309433},
    {307454, 311553, 308075, 309890},
    {308037, 311914, 308575, 310333},
    {308636, 312238, 309065, 310772},
    {309210, 312528, 309557, 311161},
    {309680, 312818, 310074, 311590},
    {310104, 313139, 310584, 311982},
    {310566, 313400, 311076, 312358},
    {310988, 313682, 311565, 312741},
    {311379, 313950, 312014, 313074},
    {311840, 314235, 312448, 313415},
    {312229, 314475, 312876, 313732},
    {312602, 314753, 313330, 314025},
    {312896, 315004, 313799, 314348},
    {313239, 315323, 314280, 314650},
    {313598, 315640, 314793, 314953},
    {313935, 315938, 315343, 315245},
    {314280, 316279, 315941, 315566},
    {314619, 316540, 316490, 315918},
    {314972, 316807, 317068, 316261},
    {315282, 317047, 317660, 316591},
    {315588, 317283, 318198, 316902},
    {315838, 317552, 318784, 317144},
    {316119, 317759, 319410, 317420},
    {316444, 317948, 319952, 317667},
    {316725, 318133, 320598, 317862},
    {316976, 318290, 321278, 318054},
    {317245, 318463, 321993, 318251},
    {317472, 318628, 322770, 318430},
    {317677, 318771, 323609, 318618},
    {317862, 318927, 324614, 318803},
    {318036, 319095, 325697, 318994},
    {318203, 319254, 326949, 319170},
    {318357, 319400, 328409, 319331},
    {318502, 319546, 330034, 319518},
    {318636, 319688, 331898, 319679},
    {318774, 319844, 333932, 319852},
    {318904, 319983, 336039, 320009},
    {319034, 320130, 338303, 320194},
    {319131, 320297, 340532, 320386},
    {319255, 320435, 342745, 320571},
    {319377, 320592, 344552, 320799},
    {319503, 320763, 345966, 321034},
    {319631, 320946, 346919, 321254},
    {319735, 321151, 347574, 321535},
    {319829, 321358, 348028, 321816},
    {319951, 321585, 348354, 322156},
    {320060, 321838, 348560, 322480},
    {320169, 322118, 348684, 322831},
    {320284, 322431, 348768, 323249},
    {320413, 322736, 348850, 323800},
    {320540, 323095, 348922, 324360},
    {320662, 323528, 348986, 324966},
    {320787, 323970, 349046, 325648},
    {320931, 324492, 349118, 326491},
    {321064, 325093, 349199, 327505},
    {321218, 325742, 349268, 328721},
    {321380, 326468, 349336, 330176},
    {321524, 327339, 349393, 332007},
    {321696, 328383, 349451, 334490},
    {321890, 329511, 349515, 337883},
    {322121, 330946, 349588, 341099},
    {322367, 332553, 349669, 344204},
    {322622, 334579, 349721, 347313},
    {322894, 336898, 349779, 348637},
    {323219, 339431, 349824, 349359},
    {323585, 341889, 349887, 349843},
    {323965, 344132, 349983, 350182},
    {324445, 345952, 350049, 350283},
    {324997, 347423, 350126, 350393},
    {325603, 348515, 350212, 350493},
    {326400, 349280, 350297, 350610},
    {327356, 349839, 350393, 350712},
    {328528, 350292, 350527, 350859},
    {330194, 350730, 350759, 351078},
    {332683, 351226, 351041, 351486},
    {336012, 351883, 352015, 352276},
    {341773, 353147, 352769, 354402},
    {394397, 394397, 394397, 394397},
  };
  uint64_t checkVals[CAPY_COLORHISTO_NBBUCKETS][nbType] = {
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 0, 0},
    {0, 0, 1, 0},
    {0, 0, 1, 0},
    {0, 0, 2, 0},
    {0, 0, 3, 0},
    {0, 1, 9, 0},
    {0, 0, 6, 0},
    {0, 1, 11, 0},
    {0, 0, 18, 0},
    {1, 3, 26, 1},
    {1, 4, 26, 0},
    {1, 13, 40, 0},
    {3, 22, 50, 1},
    {4, 31, 65, 2},
    {14, 51, 90, 8},
    {32, 59, 125, 14},
    {50, 107, 170, 32},
    {62, 158, 233, 26},
    {95, 202, 355, 71},
    {101, 234, 435, 95},
    {115, 256, 578, 122},
    {154, 336, 801, 152},
    {124, 375, 1013, 240},
    {138, 432, 1222, 251},
    {128, 471, 1534, 251},
    {141, 496, 1831, 308},
    {163, 595, 2291, 315},
    {171, 738, 2517, 383},
    {217, 859, 3014, 397},
    {231, 1029, 3198, 475},
    {231, 1245, 3685, 563},
    {260, 1336, 4006, 681},
    {282, 1643, 4323, 742},
    {361, 1910, 4580, 972},
    {405, 2136, 4693, 1181},
    {424, 2272, 4939, 1386},
    {492, 2603, 4936, 1593},
    {548, 2945, 4991, 1899},
    {589, 3288, 4942, 2062},
    {660, 3569, 4762, 2257},
    {760, 3903, 4782, 2563},
    {789, 4221, 4508, 2837},
    {996, 4487, 4363, 3146},
    {1051, 4660, 4233, 3438},
    {1201, 4768, 3981, 3804},
    {1425, 5007, 3971, 4112},
    {1576, 5057, 3768, 4490},
    {1832, 5056, 3621, 4679},
    {2002, 5107, 3653, 4809},
    {2104, 5066, 3544, 4961},
    {2332, 5163, 3453, 5089},
    {2548, 5254, 3361, 5112},
    {2889, 5214, 3407, 4950},
    {3070, 5068, 3419, 5222},
    {3340, 5057, 3222, 5231},
    {3590, 5060, 3096, 5170},
    {3884, 4896, 3138, 5173},
    {4253, 4837, 3043, 5242},
    {4368, 4840, 3143, 5019},
    {4616, 4561, 3028, 4950},
    {4721, 4548, 3111, 5005},
    {4861, 4377, 3026, 4930},
    {5016, 4446, 3105, 4767},
    {4957, 4206, 3126, 4717},
    {5010, 3907, 3114, 4716},
    {4946, 3948, 3212, 4688},
    {4909, 3837, 3104, 4513},
    {4883, 3715, 3312, 4176},
    {4958, 3464, 3171, 4031},
    {4777, 3276, 3225, 3991},
    {4616, 3417, 3322, 3742},
    {4453, 3193, 3145, 3573},
    {4515, 3182, 3309, 3444},
    {4317, 3188, 3123, 3232},
    {4240, 3188, 3173, 3187},
    {4228, 3223, 3065, 3161},
    {4166, 3241, 2930, 3093},
    {4147, 3243, 2834, 3158},
    {4202, 3118, 2604, 3036},
    {4122, 3103, 2701, 3091},
    {4267, 3242, 2638, 3143},
    {4058, 3032, 2471, 3173},
    {4189, 3044, 2565, 2955},
    {4205, 3134, 2468, 2906},
    {4343, 3074, 2471, 2842},
    {4140, 3151, 2578, 2905},
    {4142, 3117, 2457, 2827},
    {3985, 3073, 2494, 2938},
    {4005, 3199, 2458, 2902},
    {3954, 3317, 2434, 2863},
    {3964, 3169, 2355, 2828},
    {3770, 3151, 2401, 2873},
    {3762, 3052, 2399, 3032},
    {3698, 2888, 2465, 3012},
    {3788, 2874, 2431, 3059},
    {3742, 2870, 2477, 3045},
    {3752, 2943, 2621, 3068},
    {3878, 2923, 2578, 2905},
    {3605, 2918, 2479, 3008},
    {3538, 2842, 2477, 2972},
    {3397, 2832, 2619, 3049},
    {3306, 2711, 2410, 2926},
    {3207, 2482, 2314, 3005},
    {3131, 2401, 2462, 2946},
    {3018, 2236, 2199, 2840},
    {2938, 2115, 2084, 2780},
    {2908, 1952, 2059, 2654},
    {2834, 1896, 1933, 2587},
    {2805, 1800, 1997, 2504},
    {2666, 1750, 1921, 2237},
    {2573, 1658, 1771, 2191},
    {2449, 1521, 1743, 2044},
    {2308, 1396, 1735, 1998},
    {2245, 1301, 1504, 1804},
    {2237, 1187, 1468, 1769},
    {2056, 1097, 1337, 1674},
    {1917, 998, 1265, 1514},
    {1826, 1093, 1218, 1430},
    {1866, 999, 1129, 1404},
    {1709, 953, 1116, 1303},
    {1595, 886, 1063, 1155},
    {1520, 899, 972, 1143},
    {1550, 833, 981, 1030},
    {1466, 787, 942, 978},
    {1353, 803, 924, 921},
    {1386, 784, 876, 902},
    {1301, 759, 913, 875},
    {1268, 703, 842, 859},
    {1239, 672, 843, 803},
    {1206, 625, 793, 780},
    {1147, 677, 805, 768},
    {1002, 641, 782, 720},
    {955, 593, 714, 711},
    {983, 581, 677, 677},
    {943, 524, 669, 653},
    {871, 533, 689, 585},
    {852, 517, 666, 579},
    {801, 492, 662, 619},
    {786, 501, 638, 562},
    {781, 456, 575, 532},
    {775, 447, 579, 550},
    {732, 455, 604, 503},
    {735, 425, 546, 503},
    {692, 448, 605, 506},
    {687, 399, 540, 493},
    {647, 390, 581, 501},
    {660, 359, 536, 478},
    {628, 389, 508, 496},
    {620, 364, 525, 475},
    {617, 351, 508, 433},
    {607, 347, 548, 457},
    {583, 361, 500, 443},
    {599, 324, 490, 439},
    {574, 290, 492, 389},
    {470, 290, 517, 429},
    {424, 321, 510, 392},
    {462, 261, 492, 376},
    {422, 282, 489, 383},
    {391, 268, 449, 333},
    {461, 285, 434, 341},
    {389, 240, 428, 317},
    {373, 278, 454, 293},
    {294, 251, 469, 323},
    {343, 319, 481, 302},
    {359, 317, 513, 303},
    {337, 298, 550, 292},
    {345, 341, 598, 321},
    {339, 261, 549, 352},
    {353, 267, 578, 343},
    {310, 240, 592, 330},
    {306, 236, 538, 311},
    {250, 269, 586, 242},
    {281, 207, 626, 276},
    {325, 189, 542, 247},
    {281, 185, 646, 195},
    {251, 157, 680, 192},
    {269, 173, 715, 197},
    {227, 165, 777, 179},
    {205, 143, 839, 188},
    {185, 156, 1005, 185},
    {174, 168, 1083, 191},
    {167, 159, 1252, 176},
    {154, 146, 1460, 161},
    {145, 146, 1625, 187},
    {134, 142, 1864, 161},
    {138, 156, 2034, 173},
    {130, 139, 2107, 157},
    {130, 147, 2264, 185},
    {97, 167, 2229, 192},
    {124, 138, 2213, 185},
    {122, 157, 1807, 228},
    {126, 171, 1414, 235},
    {128, 183, 953, 220},
    {104, 205, 655, 281},
    {94, 207, 454, 281},
    {122, 227, 326, 340},
    {109, 253, 206, 324},
    {109, 280, 124, 351},
    {115, 313, 84, 418},
    {129, 305, 82, 551},
    {127, 359, 72, 560},
    {122, 433, 64, 606},
    {125, 442, 60, 682},
    {144, 522, 72, 843},
    {133, 601, 81, 1014},
    {154, 649, 69, 1216},
    {162, 726, 68, 1455},
    {144, 871, 57, 1831},
    {172, 1044, 58, 2483},
    {194, 1128, 64, 3393},
    {231, 1435, 73, 3216},
    {246, 1607, 81, 3105},
    {255, 2026, 52, 3109},
    {272, 2319, 58, 1324},
    {325, 2533, 45, 722},
    {366, 2458, 63, 484},
    {380, 2243, 96, 339},
    {480, 1820, 66, 101},
    {552, 1471, 77, 110},
    {606, 1092, 86, 100},
    {797, 765, 85, 117},
    {956, 559, 96, 102},
    {1172, 453, 134, 147},
    {1666, 438, 232, 219},
    {2489, 496, 282, 408},
    {3329, 657, 974, 790},
    {5761, 1264, 754, 2126},
    {52624, 41250, 41628, 39995},
  };
  double nbPixels = (double)($(img, getNbPixels)());
  loop(i, capyColorHistoType_last) loop(j, CAPY_COLORHISTO_NBBUCKETS) {
    CUTEST_ASSERT(
      fabs(
        histo->vals[i][j] -
        (double)checkVals[j][i] / nbPixels) < 1.0 / nbPixels,
      "extract failed [%d,%d]=%lf != %lf",
      i, j, histo->vals[i][j], (double)checkVals[j][i] / nbPixels);
  }
  loop(i, capyColorHistoType_last) loop(j, CAPY_COLORHISTO_NBBUCKETS) {
    double v =
      fabs(histo->cumulVals[i][j] - (double)checkCumulVals[j][i] / nbPixels);
    CUTEST_ASSERT(
      v < 1.0 / nbPixels,
      "extract failed [%d,%d]=%lf != %lf",
      i, j, histo->vals[i][j], (double)checkVals[j][i] / nbPixels);
  }
  CapyColorHistoFree(&histo);
  CUTEST_ASSERT(histo == NULL, "histo not reset");
  CapyImgFree(&img);
}

CUTEST(test002, "apply") {
  CapyColorHisto* histo = CapyColorHistoAlloc();
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorHisto/test005.png", "rb");
  CapyImg* imgRef = $(&png, loadImg)(&stream);
  $(&stream, open)("UnitTests/TestColorHisto/test006.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(histo, extract)(imgRef);
  $(histo, apply)(img, capyColorHistoType_intensity);
  $(&stream, open)("UnitTests/TestColorHisto/test006_histo.png", "rb");
  CapyImg* img_ = $(&png, loadImg)(&stream);
  forEach(pixel, img_->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        fabs(
          img_->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 1.0 / 255.0,
        "apply failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        img->pixels[pixel.idx].RGBA[i], img_->pixels[pixel.idx].RGBA[i]);
    }
  }
  CapyImgFree(&img_);
  CapyImgFree(&img);
  CapyImgFree(&imgRef);
  $(&stream, open)("UnitTests/TestColorHisto/test006.png", "rb");
  imgRef = $(&png, loadImg)(&stream);
  $(&stream, open)("UnitTests/TestColorHisto/test005.png", "rb");
  img = $(&png, loadImg)(&stream);
  $(histo, extract)(imgRef);
  $(histo, apply)(img, capyColorHistoType_intensity);
  $(&stream, open)("UnitTests/TestColorHisto/test005_histo.png", "rb");
  img_ = $(&png, loadImg)(&stream);
  forEach(pixel, img_->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        fabs(
          img_->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 1.0 / 255.0,
        "apply failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        img->pixels[pixel.idx].RGBA[i], img_->pixels[pixel.idx].RGBA[i]);
    }
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&img_);
  CapyImgFree(&img);
  CapyImgFree(&imgRef);
  CapyColorHistoFree(&histo);
}
