#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static bool FloodConditionFun(
       CapyImg const* const img,
  CapyImgPixel const* const from,
  CapyImgPixel const* const to) {
  double v =
    fabs(img->pixels[from->idx].intensity - img->pixels[to->idx].intensity);
  return (v < 0.5);
}

#endif
CUTEST(test001, "segmentImg") {
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestColorPatch/test007.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyFloodFill* flood = CapyFloodFillAlloc();
  CapyColorPatches* segments =
    $(flood, segmentImg)(img, img, FloodConditionFun);
  size_t nbSegments = $(segments, getNbPatch)();
  CUTEST_ASSERT(
    nbSegments == 8, "unexpected number of segments %ld != 8", nbSegments);
  CapyColorPatchesFree(&segments);
  CapyFloodFillFree(&flood);
  CapyImgFree(&img);
}
