#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Compare char") {
  char a = 'a';
  char b = 'b';
  CUTEST_ASSERT(
    $(&capyComparatorCharInc, eval)(&a, &b) < 0 &&
    $(&capyComparatorCharInc, eval)(&a, &a) == 0 &&
    $(&capyComparatorCharInc, eval)(&b, &a) > 0 &&
    $(&capyComparatorCharDec, eval)(&a, &b) > 0 &&
    $(&capyComparatorCharDec, eval)(&a, &a) == 0 &&
    $(&capyComparatorCharDec, eval)(&b, &a) < 0, "comparison failed");
}

CUTEST(test002, "Compare string") {
  char const* a = "abc";
  char const* b = "def";
  CUTEST_ASSERT(
    $(&capyComparatorCharInc, eval)(&a, &b) < 0 &&
    $(&capyComparatorCharInc, eval)(&a, &a) == 0 &&
    $(&capyComparatorCharInc, eval)(&b, &a) > 0 &&
    $(&capyComparatorCharDec, eval)(&a, &b) > 0 &&
    $(&capyComparatorCharDec, eval)(&a, &a) == 0 &&
    $(&capyComparatorCharDec, eval)(&b, &a) < 0, "comparison failed");
}
