#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "RLE") {
  CapyRLECompressor* compressor = CapyRLECompressorAlloc();
  char const* str = "aaaabbbbbbcddddd";
  CapyCompressorData data = {.bytes = (uint8_t*)str, .size = strlen(str) + 1};
  bool isOk = false;
  CapyCompressorData compressed = $(compressor, compress)(data);
  char check[10] = {4, 97, 6, 98, 1, 99, 5, 100, 1, 0};
  if(compressed.bytes != NULL) {
    CapyCompressorData dataBack = $(compressor, decompress)(compressed);
    isOk = (
      compressed.size == 10 &&
      dataBack.bytes != NULL &&
      memcmp(compressed.bytes, check, compressed.size) == 0 &&
      data.size == dataBack.size &&
      dataBack.bytes != NULL &&
      memcmp(data.bytes, dataBack.bytes, data.size) == 0);
    free(compressed.bytes);
    free(dataBack.bytes);
  }
  CUTEST_ASSERT(isOk, "RLE failed");
  CapyRLECompressorFree(&compressor);
}

CUTEST(test002, "BWTRLE (1)") {
  CapyBWTRLECompressor* compressor = CapyBWTRLECompressorAlloc();
  char const* str = "aaaabbbbbbcddddd";
  CapyCompressorData data = {.bytes = (uint8_t*)str, .size = strlen(str) + 1};
  bool isOk = false;
  CapyCompressorData compressed = $(compressor, compress)(data);
  char check[12] = {1, 100, 1, 0, 4, 97, 6, 98, 4, 100, 1, 99};
  if(compressed.bytes != NULL) {
    CapyCompressorData dataBack = $(compressor, decompress)(compressed);
    isOk = (
      *(size_t*)(compressed.bytes) == 2 &&
      compressed.size == 20 &&
      dataBack.bytes != NULL &&
      memcmp(compressed.bytes + sizeof(size_t), check, 12) == 0 &&
      data.size == dataBack.size &&
      dataBack.bytes != NULL &&
      memcmp(data.bytes, dataBack.bytes, data.size) == 0);
    free(compressed.bytes);
    free(dataBack.bytes);
  }
  CUTEST_ASSERT(isOk, "BWTRLE failed");
  CapyBWTRLECompressorFree(&compressor);
}

CUTEST(test003, "BWTRLE (2)") {
  CapyBWTRLECompressor* compressor = CapyBWTRLECompressorAlloc();
  char const* path = "./UnitTests/TestCompressor/test001.txt";
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)(path, "rb");
  size_t size = $(&stream, getSize)();
  char* str = NULL;
  safeMalloc(str, size);
  $(&stream, readBytes)(str, size);
  CapyCompressorData data = {.bytes = (uint8_t*)str, .size = size};
  CapyCompressorData compressed = $(compressor, compress)(data);
  CapyCompressorData dataBack = $(compressor, decompress)(compressed);
  bool isOk = (
    size == 5091 &&
    compressed.size == 5288 &&
    data.size == dataBack.size &&
    data.size == size &&
    memcmp(data.bytes, dataBack.bytes, size) == 0
  );
  CUTEST_ASSERT(isOk, "BWTRLE failed");
  $(&stream, destruct)();
  free(compressed.bytes);
  free(dataBack.bytes);
  free(str);
  CapyBWTRLECompressorFree(&compressor);
}

CUTEST(test004, "Huffman (1)") {
  CapyHuffmanCompressor* compressor = CapyHuffmanCompressorAlloc();
  char const* str = "A_DEAD_DAD_CEDED_A_BAD_BABE_A_BEADED_ABACA_BED";
  CapyCompressorData data = {.bytes = (uint8_t*)str, .size = strlen(str)};
  CapyCompressorData compressed = $(compressor, compress)(data);
  CapyCompressorData dataBack = $(compressor, decompress)(compressed);
  bool isOk = (
    data.size == 46 &&
    compressed.size == 47 &&
    data.size == dataBack.size &&
    memcmp(data.bytes, dataBack.bytes, data.size) == 0
  );
  CUTEST_ASSERT(isOk, "Huffman failed");
  free(compressed.bytes);
  free(dataBack.bytes);
  CapyHuffmanCompressorFree(&compressor);
}

CUTEST(test005, "Huffman (2)") {
  CapyHuffmanCompressor* compressor = CapyHuffmanCompressorAlloc();
  char const* path = "./UnitTests/TestCompressor/test001.txt";
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)(path, "rb");
  size_t size = $(&stream, getSize)();
  char* str = NULL;
  safeMalloc(str, size);
  $(&stream, readBytes)(str, size);
  CapyCompressorData data = {.bytes = (uint8_t*)str, .size = size};
  CapyCompressorData compressed = $(compressor, compress)(data);
  CapyCompressorData dataBack = $(compressor, decompress)(compressed);
  bool isOk = (
    size == 5091 &&
    compressed.size == 2937 &&
    data.size == dataBack.size &&
    data.size == size &&
    memcmp(data.bytes, dataBack.bytes, size) == 0
  );
  CUTEST_ASSERT(isOk, "Huffman failed");
  $(&stream, destruct)();
  free(compressed.bytes);
  free(dataBack.bytes);
  free(str);
  CapyHuffmanCompressorFree(&compressor);
}
