#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "loadFromPath/print") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  FILE* stream = fopen("UnitTests/TestDataset/dataset_desc.txt", "w");
  $(dataset, print)(stream);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestDataset/dataset_desc.txt "
      "UnitTests/TestDataset/dataset_desc_check.txt") == 0,
    "TestDataset/dataset_desc.txt and "
    "TestDataset/dataset_desc_check.txt differ.");
  CapyDatasetFree(&dataset);
}

CUTEST(test002, "cvtToMatForSingleCatPredictor") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyMat mat = $(dataset, cvtToMatForSingleCatPredictor)(0);
  CUTEST_ASSERT(mat.nbCol == 5, "nbCol=%lu!=5", mat.nbCol);
  CUTEST_ASSERT(mat.nbRow == 150, "nbRow=%lu!=150", mat.nbRow);
  CapyMatDestruct(&mat);
  CapyDatasetFree(&dataset);
}

CUTEST(test003, "cvtToMatForSingleCatPredictor") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyMat mat = $(dataset, cvtToMatForOneHotPredictor)(0);
  CUTEST_ASSERT(mat.nbCol == 7, "nbCol=%lu!=7", mat.nbCol);
  CUTEST_ASSERT(mat.nbRow == 150, "nbRow=%lu!=150", mat.nbRow);
  CapyMatDestruct(&mat);
  CapyDatasetFree(&dataset);
}

CUTEST(test004, "dataset with null values") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("UnitTests/TestDataset/dataset_null_values.csv");
  CUTEST_ASSERT(
    dataset->nbFieldWithNullValue == 2 &&
    dataset->nbRowWithNullValue == 4 &&
    dataset->fields[0].flagNullValue &&
    dataset->fields[1].flagNullValue &&
    dataset->fields[2].flagNullValue == false &&
    dataset->fields[0].nbRowWithNullValue == 3 &&
    dataset->fields[1].nbRowWithNullValue == 2 &&
    dataset->fields[2].nbRowWithNullValue == 0 &&
    fabs(dataset->fields[0].range.min - 1.0) < 1e-6 &&
    fabs(dataset->fields[0].range.max - 1.0) < 1e-6 &&
    fabs(dataset->fields[1].range.min - 0.0) < 1e-6 &&
    fabs(dataset->fields[1].range.max - 0.0) < 1e-6 &&
    fabs(dataset->fields[2].range.min - 0.0) < 1e-6 &&
    fabs(dataset->fields[2].range.max - 0.0) < 1e-6 &&
    dataset->rows[0].flagNullValue == false &&
    dataset->rows[1].flagNullValue &&
    dataset->rows[2].flagNullValue &&
    dataset->rows[3].flagNullValue &&
    dataset->rows[4].flagNullValue &&
    dataset->rows[0].nbFieldWithNullValue == 0 &&
    dataset->rows[1].nbFieldWithNullValue == 1 &&
    dataset->rows[2].nbFieldWithNullValue == 1 &&
    dataset->rows[3].nbFieldWithNullValue == 1 &&
    dataset->rows[4].nbFieldWithNullValue == 2,
    "dataset->nbFieldWithNullValue = %lu, "
    "dataset->nbRowWithNullValue = %lu, "
    "dataset->fields[0].flagNullValue = %d, "
    "dataset->fields[1].flagNullValue = %d, "
    "dataset->fields[2].flagNullValue = %d, "
    "dataset->fields[0].nbRowWithNullValue = %lu, "
    "dataset->fields[1].nbRowWithNullValue = %lu, "
    "dataset->fields[2].nbRowWithNullValue = %lu, "
    "dataset->fields[0].range.min = %lf, "
    "dataset->fields[0].range.max = %lf, "
    "dataset->fields[1].range.min = %lf, "
    "dataset->fields[1].range.max = %lf, "
    "dataset->fields[2].range.min = %lf, "
    "dataset->fields[2].range.max = %lf, "
    "dataset->rows[0].flagNullValue = %d, "
    "dataset->rows[1].flagNullValue = %d, "
    "dataset->rows[2].flagNullValue = %d, "
    "dataset->rows[3].flagNullValue = %d, "
    "dataset->rows[4].flagNullValue = %d, "
    "dataset->rows[0].nbFieldWithNullValue = %lu, "
    "dataset->rows[1].nbFieldWithNullValue = %lu, "
    "dataset->rows[2].nbFieldWithNullValue = %lu, "
    "dataset->rows[3].nbFieldWithNullValue = %lu, "
    "dataset->rows[4].nbFieldWithNullValue = %lu\n",
    dataset->nbFieldWithNullValue,
    dataset->nbRowWithNullValue,
    dataset->fields[0].flagNullValue,
    dataset->fields[1].flagNullValue,
    dataset->fields[2].flagNullValue,
    dataset->fields[0].nbRowWithNullValue,
    dataset->fields[1].nbRowWithNullValue,
    dataset->fields[2].nbRowWithNullValue,
    dataset->fields[0].range.min,
    dataset->fields[0].range.max,
    dataset->fields[1].range.min,
    dataset->fields[1].range.max,
    dataset->fields[2].range.min,
    dataset->fields[2].range.max,
    dataset->rows[0].flagNullValue,
    dataset->rows[1].flagNullValue,
    dataset->rows[2].flagNullValue,
    dataset->rows[3].flagNullValue,
    dataset->rows[4].flagNullValue,
    dataset->rows[0].nbFieldWithNullValue,
    dataset->rows[1].nbFieldWithNullValue,
    dataset->rows[2].nbFieldWithNullValue,
    dataset->rows[3].nbFieldWithNullValue,
    dataset->rows[4].nbFieldWithNullValue);
  CapyDatasetFree(&dataset);
}

CUTEST(test005, "dataset with datetime") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("UnitTests/TestDataset/dataset_datetime.csv");
  FILE* stream = fopen("UnitTests/TestDataset/dataset_desc2.txt", "w");
  $(dataset, print)(stream);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestDataset/dataset_desc2.txt "
      "UnitTests/TestDataset/dataset_desc2_check.txt") == 0,
    "TestDataset/dataset_desc2.txt and "
    "TestDataset/dataset_desc_check2.txt differ.");
  CUTEST_ASSERT(
    dataset->fields[0].type == capyDatasetFieldType_datetime1 &&
    fabs(dataset->fields[0].range.min - 2021.001389) < 1e-6 &&
    fabs(dataset->fields[0].range.max - 2021.087674) < 1e-6,
    "type=%d, min=%lf, max=%lf",
    dataset->fields[0].type, dataset->fields[0].range.min,
    dataset->fields[0].range.max);
  CapyDatasetFree(&dataset);
}

CUTEST(test006, "field average and median") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("UnitTests/TestDataset/dataset_average_median.csv");
  CUTEST_ASSERT(
    fabs(dataset->fields[0].avgVal - 15.0 / 4.0) < 1e-6 &&
    fabs(dataset->fields[0].medianVal - 2.0) < 1e-6 &&
    fabs(dataset->fields[1].avgVal - 3.0 / 5.0) < 1e-6 &&
    fabs(dataset->fields[1].medianVal - 1.0) < 1e-6,
    "avgVal[0]=%lf, medianVal[0]=%lf, avgVal[1]=%lf, medianVal[1]=%lf",
    dataset->fields[0].avgVal, dataset->fields[0].medianVal,
    dataset->fields[1].avgVal, dataset->fields[1].medianVal);
  CapyDatasetFree(&dataset);
}

CUTEST(test007, "field average and median (chlorophyll)") {
  CapySetRaiseStream(stderr);
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("UnitTests/TestDataset/dataset_chlorophyll.csv");
  CUTEST_ASSERT(
    isnan(dataset->fields[4].range.min) &&
    isnan(dataset->fields[4].range.max) &&
    isnan(dataset->fields[4].avgVal) &&
    isnan(dataset->fields[4].medianVal),
    "failed for column containing only nan value");
  CapyDatasetFree(&dataset);
}
