#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc/free") {
  CapyDate* date = CapyDateAlloc();
  CUTEST_ASSERT(
    date->vals[capyDateUnit_year] == 0 &&
    date->vals[capyDateUnit_month] == 0 &&
    date->vals[capyDateUnit_day] == 0 &&
    date->vals[capyDateUnit_hour] == 0 &&
    date->vals[capyDateUnit_minute] == 0 &&
    date->vals[capyDateUnit_second] == 0,
    "CapyDateAlloc failed");
  CapyDateFree(&date);
}

CUTEST(test002, "Set from and get as uint64_t") {
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770531193000UL);
  uint64_t d = $(date, getAsUInt64)();
  CUTEST_ASSERT(
    d == 19770531193000UL &&
    date->vals[capyDateUnit_year] == 1977 &&
    date->vals[capyDateUnit_month] == 4 &&
    date->vals[capyDateUnit_day] == 30 &&
    date->vals[capyDateUnit_hour] == 19 &&
    date->vals[capyDateUnit_minute] == 30 &&
    date->vals[capyDateUnit_second] == 0,
    "setFromUInt64 failed %lu (%d,%d,%d,%d,%d,%d)",
    d,
    date->vals[capyDateUnit_year],
    date->vals[capyDateUnit_month],
    date->vals[capyDateUnit_day],
    date->vals[capyDateUnit_hour],
    date->vals[capyDateUnit_minute],
    date->vals[capyDateUnit_second]);
  CapyDateFree(&date);
}

CUTEST(test003, "Get delay") {
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770531193000UL);
  CapyDate* dateTo = CapyDateAlloc();
  $(dateTo, setFromUInt64)(20240301111900UL);
  int64_t delay[capyDateUnit_nb] = {0};
  loop(i, capyDateUnit_nb) delay[i] = $(date, getDelayTo)(dateTo, i);
  CUTEST_ASSERT(
    delay[capyDateUnit_year] == 46 &&
    delay[capyDateUnit_month] == 560 &&
    delay[capyDateUnit_day] == 16829 &&
    delay[capyDateUnit_hour] == 403911 &&
    delay[capyDateUnit_minute] == 24234709 &&
    delay[capyDateUnit_second] == 1454082540,
    "getDelayTo failed (%ld,%ld,%ld,%ld,%ld,%ld)",
    delay[capyDateUnit_year],
    delay[capyDateUnit_month],
    delay[capyDateUnit_day],
    delay[capyDateUnit_hour],
    delay[capyDateUnit_minute],
    delay[capyDateUnit_second]);
  CapyDateFree(&date);
  CapyDateFree(&dateTo);
}

CUTEST(test004, "Get week day") {
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770531000000UL);
  CapyWeekDay day = $(date, getWeekDay)();
  CUTEST_ASSERT(
    day == capyWeekDay_tuesday, "getWeekDay failed %d", day);
  CapyDateFree(&date);
}

CUTEST(test005, "Add date (1)") {
  CapyDate delay = {.vals = {10, 9, 8, 7, 6, 5}};
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770531193000UL);
  $(date, addDate)(&delay);
  CUTEST_ASSERT(
    date->vals[capyDateUnit_year] == 1988 &&
    date->vals[capyDateUnit_month] == 2 &&
    date->vals[capyDateUnit_day] == 9 &&
    date->vals[capyDateUnit_hour] == 2 &&
    date->vals[capyDateUnit_minute] == 36 &&
    date->vals[capyDateUnit_second] == 5,
    "addDate failed (%d,%d,%d,%d,%d,%d)",
    date->vals[capyDateUnit_year],
    date->vals[capyDateUnit_month],
    date->vals[capyDateUnit_day],
    date->vals[capyDateUnit_hour],
    date->vals[capyDateUnit_minute],
    date->vals[capyDateUnit_second]);
  CapyDateFree(&date);
}

CUTEST(test006, "Add date (2)") {
  CapyDate delay = {.vals = {-10, -9, -8, -7, -6, -5}};
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770531193000UL);
  $(date, addDate)(&delay);
  CUTEST_ASSERT(
    date->vals[capyDateUnit_year] == 1966 &&
    date->vals[capyDateUnit_month] == 7 &&
    date->vals[capyDateUnit_day] == 22 &&
    date->vals[capyDateUnit_hour] == 12 &&
    date->vals[capyDateUnit_minute] == 23 &&
    date->vals[capyDateUnit_second] == 55,
    "addDate failed (%d,%d,%d,%d,%d,%d)",
    date->vals[capyDateUnit_year],
    date->vals[capyDateUnit_month],
    date->vals[capyDateUnit_day],
    date->vals[capyDateUnit_hour],
    date->vals[capyDateUnit_minute],
    date->vals[capyDateUnit_second]);
  CapyDateFree(&date);
}

CUTEST(test007, "Conversion time to cos/sin") {
  CapyDate* date = CapyDateAlloc();
  uint64_t times[4] = {
    19770531000000UL,
    19770531060000UL,
    19770531120000UL,
    19770531180000UL,
  };
  CapyDateCosSin checkCosSins[4] = {
    {.cos = 1.0, .sin = 0.0},
    {.cos = 0.0, .sin = 1.0},
    {.cos = -1.0, .sin = 0.0},
    {.cos = 0.0, .sin = -1.0},
  };
  bool isOk = true;
  loop(iTime, 4) {
    $(date, setFromUInt64)(times[iTime]);
    CapyDateCosSin cosSin = $(date, getTimeAsCosSin)();
    isOk &=
      fabs(cosSin.cos - checkCosSins[iTime].cos) < 1e-6 &&
      fabs(cosSin.sin - checkCosSins[iTime].sin) < 1e-6;
  }
  CUTEST_ASSERT(isOk, "getTimeAsCosSin failed");
  CapyDateFree(&date);
}

CUTEST(test008, "Conversion date to cos/sin") {
  CapyDate* date = CapyDateAlloc();
  uint64_t times[4] = {
    19770101000000UL,
    19770401060000UL,
    19770701120000UL,
    19771001180000UL,
  };
  CapyDateCosSin checkCosSins[4] = {
    {.cos = 1.0, .sin = 0.0},
    {.cos = 0.0, .sin = 1.0},
    {.cos = -1.0, .sin = 0.0},
    {.cos = 0.0, .sin = -1.0},
  };
  bool isOk = true;
  loop(iDate, 4) {
    $(date, setFromUInt64)(times[iDate]);
    CapyDateCosSin cosSin = $(date, getDateAsCosSin)();
    isOk &=
      fabs(cosSin.cos - checkCosSins[iDate].cos) < 1e-6 &&
      fabs(cosSin.sin - checkCosSins[iDate].sin) < 1e-6;
  }
  CUTEST_ASSERT(isOk, "getDateAsCosSin failed");
  CapyDateFree(&date);
}

CUTEST(test009, "Conversion date/time to normalised double") {
  CapyDate* date = CapyDateAlloc();
  $(date, setFromUInt64)(19770530193001);
  double const valDate = $(date, getDateAsNormalisedDouble)();
  bool const isOkDate = (fabs(valDate - 1977.416146) < 1e-6);
  CUTEST_ASSERT(isOkDate, "getDateAsNormalisedDouble failed");
  double const valTime = $(date, getTimeAsNormalisedDouble)();
  bool const isOkTime = (fabs(valTime - 0.812512) < 1e-6);
  CUTEST_ASSERT(isOkTime, "getTimeAsNormalisedDouble failed");
  CapyDateFree(&date);
}

CUTEST(test010, "Conversion date/time from normalised double") {
  CapyDate* date = CapyDateAlloc();
  $(date, setDateFromNormalisedDouble)(1977.416146);
  uint64_t const valDate = $(date, getAsUInt64)();
  bool const isOkDate = (valDate == 19770530193005);
  CUTEST_ASSERT(isOkDate, "setDateFromNormalisedDouble failed");
  $(date, setTimeFromNormalisedDouble)(0.812512);
  bool const isOkTime =
    (date->vals[capyDateUnit_hour] == 19) &&
    (date->vals[capyDateUnit_minute] == 30) &&
    (date->vals[capyDateUnit_second] == 01);
  CUTEST_ASSERT(isOkTime, "setTimeFromNormalisedDouble failed");
  CapyDateFree(&date);
}
