#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  int a;
  CapyPad(int, 0);
  double b;
} Dummy;

CapyDecDict(DictDummy, Dummy)
CapyDefDict(DictDummy, Dummy)
#endif
CUTEST(test001, "Dict operations") {
  Dummy defVal = {.a = -1, .b = -2.0};
  DictDummy* dict = DictDummyAlloc(2, defVal);
  size_t size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 0, "unexpected size %ld", size);
  Dummy val = $(dict, get)("valA");
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 1, "unexpected size %ld", size);
  CUTEST_ASSERT(val.a == defVal.a, "get failed %d != %d", val.a, defVal.a);
  CUTEST_ASSERT(
    equal(val.b, defVal.b), "get failed %lf != %lf", val.b, defVal.b);
  val.a = 1;
  val.b = 2.0;
  $(dict, set)("valB", val);
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 2, "unexpected size %ld", size);
  val = $(dict, get)("valB");
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 2, "unexpected size %ld", size);
  CUTEST_ASSERT(val.a == 1, "get failed %d", val.a);
  CUTEST_ASSERT(equal(val.b, 2.0), "get failed %lf", val.b);
  val.a = 3;
  val.b = 4.0;
  $(dict, set)("valC", val);
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 3, "unexpected size %ld", size);
  val = $(dict, get)("valC");
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 3, "unexpected size %ld", size);
  CUTEST_ASSERT(val.a == 3, "get failed %d", val.a);
  CUTEST_ASSERT(equal(val.b, 4.0), "get failed %lf", val.b);
  DictDummy* clone = $(dict, clone)();
  size = $(clone, getNbEntry)();
  CUTEST_ASSERT(size == 3, "clone failed");
  val = $(clone, get)("valC");
  CUTEST_ASSERT(val.a == 3, "clone failed %d", val.a);
  CUTEST_ASSERT(equal(val.b, 4.0), "clone failed %lf", val.b);
  DictDummyFree(&dict);
  DictDummyFree(&clone);
}

CUTEST(test002, "Dict iterator operations (hash size < nb entry)") {
  DictDummy* dict = DictDummyAlloc(2, (Dummy){0});
  char const* lbls[] = {"a", "b", "c", "d", "e"};
  loop(i, 5) {
    Dummy val = {.a = i, .b = i * 2};
    $(dict, set)(lbls[i], val);
  }
  forEach(entry, dict->iter) {
    CUTEST_ASSERT(
      strcmp(entry.key, lbls[entry.val.a]) == 0,
      "iter failed %s != %s", entry.key, lbls[entry.val.a]);
  }
  DictDummyFree(&dict);
}

CUTEST(test003, "Dict iterator operations (hash size > nb entry)") {
  DictDummy* dict = DictDummyAlloc(10, (Dummy){0});
  char const* lbls[] = {"a", "b", "c", "d", "e"};
  loop(i, 5) {
    Dummy val = {.a = i, .b = i * 2};
    $(dict, set)(lbls[i], val);
  }
  forEach(entry, dict->iter) {
    CUTEST_ASSERT(
      strcmp(entry.key, lbls[entry.val.a]) == 0,
      "iter failed %s != %s", entry.key, lbls[entry.val.a]);
  }
  DictDummyFree(&dict);
}

CUTEST(test004, "Remove entry") {
  DictDummy* dict = DictDummyAlloc(10, (Dummy){0});
  char const* lbls[] = {"a", "b", "c", "d", "e"};
  loop(i, 5) {
    Dummy val = {.a = i, .b = i * 2};
    $(dict, set)(lbls[i], val);
  }
  bool hasKey = $(dict, hasKey)("a");
  CUTEST_ASSERT(hasKey, "dict has no key 'a'");
  $(dict, remove)("a");
  hasKey = $(dict, hasKey)("a");
  CUTEST_ASSERT(hasKey == false, "key 'a' was not removed");
  size_t size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 4, "unexpected size %ld", size);
  $(dict, remove)("f");
  size = $(dict, getNbEntry)();
  CUTEST_ASSERT(size == 4, "unexpected size %ld", size);
  DictDummyFree(&dict);
}

