#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "ELO operations") {
  CapyElo* elo = CapyEloAlloc();
  CapyRandom rnd = CapyRandomCreate(0);
  double scores[3] = {0.0, 0.0, 0.0};
  double delta[3] = {0.0, 0.0, 0.0};
  CapyRangeDouble ranges[3] = {
    CapyRangeDoubleCreate(0.0, 0.5),
    CapyRangeDoubleCreate(0.33, 0.66),
    CapyRangeDoubleCreate(0.5, 1.0),
  };
  double check[][3] = {
    {-16.000000, 16.000000, 0.000000},
    {-298.394285, -1.321635, 299.715919},
    {-360.417493, 1.124025, 359.293469},
    {-396.532348, 11.346536, 385.185812},
    {-403.658549, -29.483877, 433.142426},
    {-410.936963, -17.469356, 428.406319},
    {-368.438761, -32.432093, 400.870853},
    {-417.421987, -15.543022, 432.965009},
    {-452.033096, 82.218268, 369.814828},
    {-389.966378, -43.684675, 433.651052},
    {-407.488320, -4.535275, 412.023596},
    {-433.735817, -22.614644, 456.350460},
    {-407.368796, -35.893174, 443.261970},
    {-448.122818, 18.113366, 430.009452},
    {-451.206850, 83.986900, 367.219950},
    {-410.913446, -10.838762, 421.752209},
    {-424.925139, -13.212183, 438.137322},
    {-382.918661, -38.290825, 421.209485},
    {-385.121612, -59.203677, 444.325289},
    {-432.699381, 6.715350, 425.984031},
  };
  loop(iRound, 1000) {
    loop(i, 3) delta[i] = 0.0;
    loop(i, 3) loop(j, i) {
      CapyEloResult result;
      double a = $(&rnd, getDoubleRange)(ranges + i);
      double b = $(&rnd, getDoubleRange)(ranges + j);
      if(equal(a, b)) result = capyElo_tie;
      else if(a > b) result = capyElo_win;
      else result = capyElo_loose;
      double d = $(elo, get)(scores[i], result, scores[j]);
      delta[i] += d;
      delta[j] -= d;
    }
    loop(i, 3) scores[i] += delta[i];
    if((iRound % 50) == 0) {
      loop(i, 3) {
        CUTEST_ASSERT(
          fabs(scores[i] - check[iRound / 50][i]) < 0.0001,
          "unexpected score [%d,%d]=%f != %f",
          iRound, i, scores[i], check[iRound / 50][i]);
      }
    }
  }
  CapyEloFree(&elo);
  $(&rnd, destruct)();
}
