#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static void TestEven(CapyFeistelCipherMode const opMode) {
  CapyArrChar initVector = CapyArrCharCreate(5);
  char iv[5] = "=()'";
  loop(i, 5) initVector.data[i] = iv[i];
  #define MSG_EVEN "Hello world!"
  CapyArrChar msg = CapyArrCharCreate(strlen(MSG_EVEN));
  memcpy(msg.data, MSG_EVEN, strlen(MSG_EVEN));
  CapyFeistelCipher* cipher = CapyFeistelCipherAlloc(opMode);
  $(cipher, setInitVector)(&initVector);
  CapyFeistelRoundFun roundFun = CapyFeistelRoundFunCreate();
  CapyListArrChar listKeys = CapyListArrCharCreate();
  #define nbKeys 3
  char const* keys[nbKeys] = {"123", "456", "789"};
  loop(i, nbKeys) {
    CapyArrChar key = CapyArrCharCreate(strlen(keys[i]));
    memcpy(key.data, keys[i], strlen(keys[i]));
    $(&listKeys, add)(key);
  }
  CapyArrChar* encodedMsg =
    $(cipher, cipher)(&roundFun, &listKeys, &msg);
  $(cipher, setInitVector)(&initVector);
  cipher->counter = 0;
  CapyArrChar* decodedMsg =
    $(cipher, decipher)(&roundFun, &listKeys, encodedMsg);
  loop(i, msg.size) {
    CUTEST_ASSERT(
      msg.data[i] == decodedMsg->data[i],
      "message corrupted [%lu]=%c != %c", i, msg.data[i], decodedMsg->data[i]);
  }
  CapyArrCharFree(&decodedMsg);
  CapyArrCharFree(&encodedMsg);
  while($(&listKeys, getSize)() > 0) {
    CapyArrChar key = $(&listKeys, pop)();
    $(&key, destruct)();
  }
  $(&listKeys, destruct)();
  $(&roundFun, destruct)();
  CapyFeistelCipherFree(&cipher);
  $(&msg, destruct)();
  $(&initVector, destruct)();
}

static void TestOdd(CapyFeistelCipherMode const opMode) {
  CapyArrChar initVector = CapyArrCharCreate(5);
  char const iv[5] = "=()'";
  loop(i, 5) initVector.data[i] = iv[i];
  #define MSG_ODD "Hello world !"
  CapyArrChar msg = CapyArrCharCreate(strlen(MSG_ODD));
  memcpy(msg.data, MSG_ODD, strlen(MSG_ODD));
  CapyFeistelCipher* cipher = CapyFeistelCipherAlloc(opMode);
  $(cipher, setInitVector)(&initVector);
  CapyFeistelRoundFun roundFun = CapyFeistelRoundFunCreate();
  CapyListArrChar listKeys = CapyListArrCharCreate();
  #define nbKeys 3
  char const* keys[nbKeys] = {"123", "456", "789"};
  loop(i, nbKeys) {
    CapyArrChar key = CapyArrCharCreate(strlen(keys[i]));
    memcpy(key.data, keys[i], strlen(keys[i]));
    $(&listKeys, add)(key);
  }
  CapyArrChar* encodedMsg = $(cipher, cipher)(&roundFun, &listKeys, &msg);
  $(cipher, setInitVector)(&initVector);
  cipher->counter = 0;
  CapyArrChar* decodedMsg =
    $(cipher, decipher)(&roundFun, &listKeys, encodedMsg);
  loop(i, msg.size) {
    CUTEST_ASSERT(
      msg.data[i] == decodedMsg->data[i],
      "message corrupted [%lu]=%c != %c", i, msg.data[i], decodedMsg->data[i]);
  }
  CapyArrCharFree(&decodedMsg);
  CapyArrCharFree(&encodedMsg);
  while($(&listKeys, getSize)() > 0) {
    CapyArrChar key = $(&listKeys, pop)();
    $(&key, destruct)();
  }
  $(&listKeys, destruct)();
  $(&roundFun, destruct)();
  CapyFeistelCipherFree(&cipher);
  $(&msg, destruct)();
  $(&initVector, destruct)();
}

#endif
CUTEST(test001, "ECB even") {
  TestEven(capyFeistelCipher_ECB);
}

CUTEST(test002, "ECB odd") {
  TestOdd(capyFeistelCipher_ECB);
}

CUTEST(test003, "CBC even") {
  TestEven(capyFeistelCipher_CBC);
}

CUTEST(test004, "CBC odd") {
  TestOdd(capyFeistelCipher_CBC);
}

CUTEST(test005, "CTR even") {
  TestEven(capyFeistelCipher_CTR);
}

CUTEST(test006, "CTR odd") {
  TestOdd(capyFeistelCipher_CTR);
}
